/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlExFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;

public class SqlString
extends SqlData {
    private String value = null;

    public SqlString() {
        super(true);
    }

    public SqlString(String string) {
        super(false);
        this.value = string;
    }

    public void set(String string) {
        this.setNotNull();
        this.value = string;
    }

    public void set(SqlString sqlString) {
        if (sqlString == null || sqlString.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlString.value;
        }
    }

    public String get() {
        return this.value;
    }

    @Override
    public void setBoolean(boolean bl) throws SQLException {
        this.setString(Boolean.toString(bl));
    }

    @Override
    public void setByte(byte by) throws SQLException {
        this.setString(Byte.toString(by));
    }

    @Override
    public void setShort(short s) throws SQLException {
        this.setString(Short.toString(s));
    }

    @Override
    public void setInt(int n) throws SQLException {
        this.setString(Integer.toString(n));
    }

    @Override
    public void setLong(long l) throws SQLException {
        this.setString(Long.toString(l));
    }

    @Override
    public void setFloat(float f) throws SQLException {
        this.setString(Float.toString(f));
    }

    @Override
    public void setDouble(double d) throws SQLException {
        this.setString(Double.toString(d));
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setString(bigDecimal.toString());
        }
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = string;
        }
    }

    @Override
    public void setDate(java.sql.Date date, TimeZone timeZone) throws SQLException {
        if (date == null) {
            this.setNull();
        } else {
            SqlDates sqlDates = SqlDates.getDefaultInstance();
            if (timeZone != null) {
                this.setString(sqlDates.formatDate((Date)date, timeZone));
            } else {
                this.setString(sqlDates.formatDate((Date)date, false));
            }
        }
    }

    @Override
    public void setTime(Time time, TimeZone timeZone) throws SQLException {
        if (time == null) {
            this.setNull();
        } else {
            SqlDates sqlDates = SqlDates.getDefaultInstance();
            if (timeZone != null) {
                this.setString(sqlDates.formatTime((Date)time, timeZone));
            } else {
                this.setString(sqlDates.formatTime((Date)time, false));
            }
        }
    }

    @Override
    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SQLException {
        if (timestamp == null) {
            this.setNull();
        } else {
            SqlDates sqlDates = SqlDates.getDefaultInstance();
            if (timeZone != null) {
                this.setString(sqlDates.formatTimestamp((Date)timestamp, timeZone));
            } else {
                this.setString(sqlDates.formatTimestamp((Date)timestamp, false));
            }
        }
    }

    @Override
    public boolean getBoolean() throws SQLException {
        String string = this.value.trim();
        return string.equals("1") ? true : Boolean.valueOf(string);
    }

    @Override
    public byte getByte() throws SQLException {
        byte by;
        try {
            by = Byte.parseByte(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return by;
    }

    @Override
    public short getShort() throws SQLException {
        short s;
        try {
            s = Short.parseShort(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return s;
    }

    @Override
    public int getInt() throws SQLException {
        int n;
        try {
            n = Integer.parseInt(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return n;
    }

    @Override
    public long getLong() throws SQLException {
        long l;
        try {
            l = Long.parseLong(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return l;
    }

    @Override
    public float getFloat() throws SQLException {
        float f;
        try {
            f = Float.parseFloat(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return f;
    }

    @Override
    public double getDouble() throws SQLException {
        double d;
        try {
            d = Double.parseDouble(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return d;
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        return bigDecimal;
    }

    @Override
    public String getString() throws SQLException {
        return this.value;
    }

    @Override
    public String getString(int n) throws SQLException {
        return n < this.value.length() ? this.value.substring(0, n) : this.value;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        return this.value.getBytes();
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        String string = n < this.value.length() ? this.value.substring(0, n) : this.value;
        return string.getBytes();
    }

    @Override
    public java.sql.Date getDate(TimeZone timeZone) throws SQLException {
        SqlDates sqlDates = SqlDates.getDefaultInstance();
        return timeZone == null ? sqlDates.parseDate(this.value.trim(), false) : sqlDates.parseDate(this.value.trim(), timeZone);
    }

    @Override
    public Time getTime(TimeZone timeZone) throws SQLException {
        SqlDates sqlDates = SqlDates.getDefaultInstance();
        return timeZone == null ? sqlDates.parseTime(this.value.trim(), false) : sqlDates.parseTime(this.value.trim(), timeZone);
    }

    @Override
    public Timestamp getTimestamp(TimeZone timeZone) throws SQLException {
        SqlDates sqlDates = SqlDates.getDefaultInstance();
        return timeZone == null ? sqlDates.parseTimestamp(this.value.trim(), false) : sqlDates.parseTimestamp(this.value.trim(), timeZone);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        byte[] byArray = this.value.getBytes();
        return SqlString.getBinary(byArray, 0, byArray.length);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return SqlString.getAscii(this.value);
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        return SqlString.getUnicode(this.value);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return SqlString.getCharacter(this.value);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getString();
    }

    @Override
    public Object getObject(int n) throws SQLException {
        return this.getString(n);
    }
}

