/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.ErrRsrc;
import com.ingres.gcf.util.SqlExType;
import com.ingres.gcf.util.Trace;
import java.sql.SQLException;

public final class SqlExFactory {
    public static SQLException get(ErrInfo errInfo) {
        String string;
        try {
            string = ErrRsrc.getResource().getString(errInfo.id);
        }
        catch (Exception exception) {
            string = errInfo.name;
        }
        return SqlExType.getSqlEx(null, string, errInfo.sqlState, errInfo.code);
    }

    public static SQLException get(String string, String string2, int n) {
        return SqlExType.getSqlEx(null, string, string2, n);
    }

    public static SQLException get(ErrInfo errInfo, SqlExType sqlExType) {
        String string;
        try {
            string = ErrRsrc.getResource().getString(errInfo.id);
        }
        catch (Exception exception) {
            string = errInfo.name;
        }
        return SqlExType.getSqlEx(sqlExType, string, errInfo.sqlState, errInfo.code);
    }

    public static SQLException get(ErrInfo errInfo, SQLException sQLException) {
        SQLException sQLException2 = SqlExFactory.get(errInfo);
        sQLException2.setNextException(sQLException);
        return sQLException2;
    }

    public static SQLException get(ErrInfo errInfo, Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception.toString();
        }
        SQLException sQLException = string == null ? SqlExFactory.get(errInfo) : SqlExFactory.get(errInfo, new SQLException(string));
        return sQLException;
    }

    public static void trace(SQLException sQLException, Trace trace) {
        for (SQLException sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            trace.write("Exception: " + sQLException2.getSQLState() + ", 0x" + Integer.toHexString(sQLException2.getErrorCode()));
            trace.write("  Message: " + sQLException2.getMessage());
        }
    }

    public static class ErrInfo {
        public int code;
        public String sqlState;
        public String id;
        public String name;

        public ErrInfo(int n, String string, String string2, String string3) {
            this.code = n;
            this.sqlState = string;
            this.id = string2;
            this.name = string3;
        }
    }
}

