/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlExFactory;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;

public class IngresDate
extends SqlData {
    private String value = null;
    private String empty_date = "";
    private boolean osql_dates = false;
    private boolean use_gmt = false;
    private boolean interval = false;
    private SqlDates dates;

    public IngresDate(boolean bl, boolean bl2) {
        super(true);
        this.osql_dates = bl;
        this.use_gmt = bl2;
        this.dates = SqlDates.getDefaultInstance();
    }

    public IngresDate(SqlDates sqlDates, boolean bl, boolean bl2) {
        super(true);
        this.osql_dates = bl;
        this.use_gmt = bl2;
        this.dates = sqlDates;
    }

    public IngresDate(boolean bl, boolean bl2, String string) {
        this(bl, bl2);
        this.empty_date = string;
    }

    public IngresDate(SqlDates sqlDates, boolean bl, boolean bl2, String string) {
        this(sqlDates, bl, bl2);
        this.empty_date = string;
    }

    public void set(String string) {
        if (string == null || string.length() == 0 && this.empty_date == null) {
            super.setNull();
        } else {
            this.setNotNull();
            this.value = string;
            this.interval = false;
        }
    }

    public void set(IngresDate ingresDate) {
        if (ingresDate == null || ingresDate.isNull()) {
            super.setNull();
        } else {
            this.setNotNull();
            this.value = ingresDate.value;
            this.interval = ingresDate.interval;
        }
    }

    public String get() {
        return this.value != null && this.value.length() == 0 ? " " : this.value;
    }

    public boolean isInterval() {
        return !this.isNull() && this.interval;
    }

    @Override
    public boolean isTruncated() {
        return !this.isNull() && !this.interval && this.value.length() != "yyyy-MM-dd HH:mm:ss".length();
    }

    @Override
    public int getDataSize() {
        return "yyyy-MM-dd HH:mm:ss".length();
    }

    @Override
    public int getTruncSize() {
        return this.value.length();
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            if (this.empty_date != null) {
                super.setNull();
            } else {
                this.setNotNull();
                this.value = "";
                this.interval = false;
            }
        } else if (string.length() == 0 || string.equals(this.empty_date)) {
            this.setNotNull();
            this.value = "";
            this.interval = false;
        } else {
            Timestamp timestamp;
            try {
                timestamp = Timestamp.valueOf(string);
            }
            catch (Exception exception) {
                java.sql.Date date;
                try {
                    date = java.sql.Date.valueOf(string);
                }
                catch (Exception exception2) {
                    Time time;
                    try {
                        time = Time.valueOf(string);
                    }
                    catch (Exception exception3) {
                        throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
                    }
                    this.setTime(time, null);
                    return;
                }
                this.setDate(date, null);
                return;
            }
            this.setTimestamp(timestamp, null);
        }
    }

    @Override
    public void setDate(java.sql.Date date, TimeZone timeZone) throws SQLException {
        if (date == null) {
            if (this.empty_date != null) {
                super.setNull();
            } else {
                this.setNotNull();
                this.interval = false;
                this.value = "";
            }
        } else {
            java.sql.Date date2 = null;
            this.setNotNull();
            this.interval = false;
            if (this.empty_date == null) {
                this.value = timeZone != null ? this.dates.formatDate((Date)date, timeZone) : this.dates.formatDate((Date)date, false);
            } else {
                if (this.empty_date.length() == 0 || this.empty_date.length() == "HH:mm:ss".length()) {
                    if (timeZone == null) {
                        date2 = SqlDates.getEpochDate();
                    } else {
                        String string = "1970-01-01";
                        date2 = this.dates.parseDate(string, timeZone);
                    }
                } else if (this.empty_date.length() == "yyyy-MM-dd".length()) {
                    date2 = timeZone == null ? this.dates.parseDate(this.empty_date, false) : this.dates.parseDate(this.empty_date, timeZone);
                } else if (this.empty_date.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                    String string = this.dates.formatDate((Date)this.dates.parseTimestamp(this.empty_date, false), false);
                    date2 = this.dates.parseDate(string, false);
                }
                this.value = date2 != null && date2.getTime() == date.getTime() ? "" : (timeZone != null ? this.dates.formatDate((Date)date, timeZone) : this.dates.formatDate((Date)date, false));
            }
        }
    }

    @Override
    public void setTime(Time time, TimeZone timeZone) throws SQLException {
        if (time == null) {
            if (this.empty_date != null) {
                super.setNull();
            } else {
                this.setNotNull();
                this.value = "";
                this.interval = false;
            }
        } else {
            if (this.osql_dates && timeZone != null) {
                String string = this.dates.formatTime((Date)time, timeZone);
                time = this.dates.parseTime(string, false);
            }
            this.setNotNull();
            this.value = this.dates.formatTimestamp((Date)time, this.use_gmt);
            this.interval = false;
        }
    }

    @Override
    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SQLException {
        if (timestamp == null) {
            if (this.empty_date != null) {
                super.setNull();
            } else {
                this.setNotNull();
                this.interval = false;
                this.value = "";
            }
        } else {
            Object object;
            Timestamp timestamp2 = null;
            if (this.osql_dates && timeZone != null) {
                object = this.dates.formatTimestamp((Date)timestamp, timeZone);
                timestamp = this.dates.parseTimestamp((String)object, false);
            }
            this.setNotNull();
            this.interval = false;
            if (this.empty_date == null) {
                this.value = this.dates.formatTimestamp((Date)timestamp, this.use_gmt);
            } else {
                if (this.empty_date.length() == 0) {
                    timestamp2 = timeZone == null ? SqlDates.getEpochTimestamp() : this.dates.parseTimestamp("1970-01-01 00:00:00", timeZone);
                } else if (this.empty_date.length() == "HH:mm:ss".length()) {
                    object = timeZone == null ? this.dates.parseTime(this.empty_date, false) : this.dates.parseTime(this.empty_date, timeZone);
                    timestamp2 = new Timestamp(((Date)object).getTime());
                } else if (this.empty_date.length() == "yyyy-MM-dd".length()) {
                    object = timeZone == null ? this.dates.parseDate(this.empty_date, false) : this.dates.parseDate(this.empty_date, timeZone);
                    timestamp2 = new Timestamp(((Date)object).getTime());
                } else if (this.empty_date.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                    timestamp2 = timeZone == null ? this.dates.parseTimestamp(this.empty_date, false) : this.dates.parseTimestamp(this.empty_date, timeZone);
                }
                this.value = timestamp2 != null && timestamp2.getTime() == timestamp.getTime() ? "" : this.dates.formatTimestamp((Date)timestamp, this.use_gmt);
            }
        }
    }

    @Override
    public String getString() throws SQLException {
        String string;
        try {
            if (this.value.length() == 0) {
                string = this.empty_date;
            } else if (this.value.length() == "yyyy-MM-dd".length()) {
                java.sql.Date date = this.dates.parseDate(this.value, false);
                string = this.dates.formatDate((Date)date, false);
            } else if (this.value.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                Timestamp timestamp = this.dates.parseTimestamp(this.value, this.use_gmt);
                string = this.dates.formatTimestamp((Date)timestamp, false);
            } else {
                this.interval = true;
                string = this.value;
            }
        }
        catch (SQLException sQLException) {
            this.interval = true;
            string = this.value;
        }
        return string;
    }

    @Override
    public java.sql.Date getDate(TimeZone timeZone) throws SQLException {
        try {
            if (this.value.length() == 0) {
                String string;
                if (this.empty_date.length() == 0 || this.empty_date.length() == "HH:mm:ss".length()) {
                    if (timeZone == null) {
                        return SqlDates.getEpochDate();
                    }
                    string = "1970-01-01";
                } else if (this.empty_date.length() == "yyyy-MM-dd".length()) {
                    string = this.empty_date;
                } else if (this.empty_date.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                    string = this.dates.formatDate((Date)this.dates.parseTimestamp(this.empty_date, false), false);
                } else {
                    throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
                }
                return timeZone == null ? this.dates.parseDate(string, false) : this.dates.parseDate(string, timeZone);
            }
            if (this.value.length() == "yyyy-MM-dd".length()) {
                return timeZone == null ? this.dates.parseDate(this.value, false) : this.dates.parseDate(this.value, timeZone);
            }
            if (this.value.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                String string = this.dates.formatDate((Date)this.dates.parseTimestamp(this.value, this.use_gmt), false);
                return this.osql_dates && timeZone != null ? this.dates.parseDate(string, timeZone) : this.dates.parseDate(string, false);
            }
            throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
        }
        catch (SQLException sQLException) {
            this.interval = true;
            throw sQLException;
        }
    }

    @Override
    public Time getTime(TimeZone timeZone) throws SQLException {
        try {
            if (this.value.length() == 0) {
                String string;
                if (this.empty_date.length() == 0 || this.empty_date.length() == "yyyy-MM-dd".length()) {
                    if (timeZone == null) {
                        return SqlDates.getEpochTime();
                    }
                    string = "00:00:00";
                } else if (this.empty_date.length() == "HH:mm:ss".length()) {
                    string = this.empty_date;
                } else if (this.empty_date.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                    string = this.dates.formatTime((Date)this.dates.parseTimestamp(this.empty_date, false), false);
                } else {
                    throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
                }
                return timeZone == null ? this.dates.parseTime(string, false) : this.dates.parseTime(string, timeZone);
            }
            if (this.value.length() == "yyyy-MM-dd".length()) {
                return timeZone == null ? SqlDates.getEpochTime() : this.dates.parseTime("00:00:00", timeZone);
            }
            if (this.value.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                String string = this.dates.formatTime((Date)this.dates.parseTimestamp(this.value, this.use_gmt), false);
                return this.osql_dates && timeZone != null ? this.dates.parseTime(string, timeZone) : this.dates.parseTime(string, false);
            }
            throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
        }
        catch (SQLException sQLException) {
            this.interval = true;
            throw sQLException;
        }
    }

    @Override
    public Timestamp getTimestamp(TimeZone timeZone) throws SQLException {
        try {
            if (this.value.length() == 0) {
                String string;
                if (this.empty_date.length() == 0) {
                    if (timeZone == null) {
                        return SqlDates.getEpochTimestamp();
                    }
                    string = "1970-01-01 00:00:00";
                } else {
                    if (this.empty_date.length() == "HH:mm:ss".length()) {
                        Time time = timeZone == null ? this.dates.parseTime(this.empty_date, false) : this.dates.parseTime(this.empty_date, timeZone);
                        return new Timestamp(time.getTime());
                    }
                    if (this.empty_date.length() == "yyyy-MM-dd".length()) {
                        java.sql.Date date = timeZone == null ? this.dates.parseDate(this.empty_date, false) : this.dates.parseDate(this.empty_date, timeZone);
                        return new Timestamp(date.getTime());
                    }
                    if (this.empty_date.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                        string = this.empty_date;
                    } else {
                        throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
                    }
                }
                return timeZone == null ? this.dates.parseTimestamp(string, false) : this.dates.parseTimestamp(string, timeZone);
            }
            if (this.value.length() == "yyyy-MM-dd".length()) {
                java.sql.Date date = timeZone == null ? this.dates.parseDate(this.value, false) : this.dates.parseDate(this.value, timeZone);
                return new Timestamp(date.getTime());
            }
            if (this.value.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                Timestamp timestamp = this.dates.parseTimestamp(this.value, this.use_gmt);
                if (this.osql_dates && timeZone != null) {
                    timestamp = this.dates.parseTimestamp(this.dates.formatTimestamp((Date)timestamp, false), timeZone);
                }
                return timestamp;
            }
            throw SqlExFactory.get(ERR_GC401B_INVALID_DATE);
        }
        catch (SQLException sQLException) {
            this.interval = true;
            throw sQLException;
        }
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getTimestamp(null);
    }

    @Override
    public void setNull() {
        if (this.empty_date == null) {
            this.setNotNull();
            this.value = "";
            this.interval = false;
        } else {
            super.setNull();
        }
    }
}

