/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvBlob;
import com.ingres.gcf.jdbc.DrvClob;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvLOB;
import com.ingres.gcf.jdbc.DrvNlob;
import com.ingres.gcf.jdbc.JdbcBlob;
import com.ingres.gcf.jdbc.JdbcClob;
import com.ingres.gcf.jdbc.JdbcPrep;
import com.ingres.gcf.jdbc.JdbcQPMD;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcStmt;
import com.ingres.gcf.jdbc.ParamSet;
import com.ingres.gcf.jdbc.ProcInfo;
import com.ingres.gcf.jdbc.RsltSlct;
import com.ingres.gcf.jdbc.SqlParse;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlExFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Map;

public class JdbcCall
extends JdbcPrep
implements CallableStatement {
    private static final int NONE = 0;
    private static final int ORDINAL = 1;
    private static final int NAME = 2;
    private static final int[] noMap = new int[0];
    private ProcInfo procInfo;
    private JdbcQPMD procQPMD = null;
    private int procRsltIndex = -1;
    private boolean hasByRefParam = false;
    private RsltSlct resultRow = null;
    private boolean null_param = false;
    private int access_type = 0;
    private int[] dpMap = noMap;
    private int[] opMap = noMap;
    private int[] opType = noMap;
    private int[] opScale = noMap;

    JdbcCall(DrvConn drvConn, String string) throws SQLException {
        super(drvConn, 1003, 0, 2, false);
        this.title = this.trace.getTraceName() + "-CallableStatement[" + this.inst_id + "]";
        this.tr_id = "Call[" + this.inst_id + "]";
        boolean bl = false;
        try {
            SqlParse sqlParse = new SqlParse(string, drvConn);
            this.procInfo = new ProcInfo(drvConn);
            sqlParse.parseCall(this.procInfo);
            bl = sqlParse.getQueryType() == 5;
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ": error parsing query text");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
        int n = this.procInfo.getParamCount();
        int n2 = 0;
        int n3 = 0;
        block6: for (int i = 0; i < n; ++i) {
            switch (this.procInfo.getParamType(i)) {
                case 1: {
                    ++n3;
                    continue block6;
                }
                case 0: {
                    ++n2;
                }
            }
        }
        if (n > 0) {
            if (n == n2) {
                this.procInfo.clearParams();
            } else if (n != n3 && !this.procInfo.paramNamesLoaded()) {
                this.procInfo.loadParamNames();
            }
        }
        if (this.procInfo.getReturn()) {
            this.procRsltIndex = bl ? ++n3 : 1;
        }
        this.dpMap = n3 > 0 ? new int[n3] : noMap;
        this.opMap = n > 0 ? new int[n] : noMap;
        this.opType = new int[n + 1];
        this.opScale = new int[n + 1];
        this.initParameters();
    }

    private synchronized void initParameters() throws SQLException {
        int n;
        boolean bl = this.procInfo.paramNamesLoaded();
        int n2 = this.procInfo.getParamCount();
        int n3 = 0;
        this.access_type = 0;
        this.hasByRefParam = false;
        for (n = 0; n < this.opMap.length; ++n) {
            this.opMap[n] = -1;
        }
        this.opType[this.opType.length - 1] = 4;
        this.opScale[this.opScale.length - 1] = -1;
        if (this.isProcRslt(1)) {
            this.dpMap[n3++] = -1;
        }
        this.params.setDefaultFlags((short)1);
        for (n = 0; n < n2; ++n) {
            switch (this.procInfo.getParamType(n)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.dpMap[n3++] = n;
                    break;
                }
                case 7: {
                    this.params.init(n, 12, true);
                    this.params.setObject(n, this.procInfo.getParamValue(n), 12);
                    this.params.setFlags(n, (short)4);
                    break;
                }
                default: {
                    Object object = this.procInfo.getParamValue(n);
                    this.params.init(n, object);
                    this.params.setObject(n, object);
                }
            }
            if (!bl) continue;
            this.params.setName(n, this.procInfo.getParamName(n));
        }
        while (n3 < this.dpMap.length) {
            this.dpMap[n3] = -1;
            ++n3;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeQuery()");
        }
        if (this.hasByRefParam) {
            throw SqlExFactory.get(ERR_GC4015_INVALID_OUT_PARAM);
        }
        this.checkParams(this.params);
        this.exec(this.params);
        if (this.resultSet == null) {
            throw SqlExFactory.get(ERR_GC4017_NO_RESULT_SET);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeQuery(): " + this.resultSet);
        }
        return this.resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate()");
        }
        this.checkParams(this.params);
        this.exec(this.params);
        if (this.resultSet != null) {
            try {
                this.resultSet.shut();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.resultSet = null;
            throw SqlExFactory.get(ERR_GC4018_RESULT_SET_NOT_PERMITTED);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate(): 0");
        }
        return 0;
    }

    @Override
    public boolean execute() throws SQLException {
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute()");
        }
        this.checkParams(this.params);
        this.exec(this.params);
        boolean bl2 = bl = this.resultSet != null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute(): " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        boolean bl = false;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".addBatch()");
        }
        this.checkParams(this.params);
        if (this.batch == null) {
            this.newBatch();
        }
        LinkedList linkedList = this.batch;
        synchronized (linkedList) {
            if (this.hasByRefParam) {
                this.batch.addLast(null);
                this.params.clear(false);
            } else {
                this.batch.addLast(this.params);
                this.params = new ParamSet(this.conn);
            }
            this.initParameters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeBatch()");
        }
        if (this.batch == null) {
            return BatchExec.noResults;
        }
        if ((this.conn.cnf_flags & 0x200) == 0 || this.conn.db_protocol_level < 6) {
            nArray = this.iterateBatch();
        } else {
            LinkedList linkedList = this.batch;
            synchronized (linkedList) {
                BatchExec batchExec = new BatchExec(this.conn);
                try {
                    nArray = batchExec.execute(this.batch, this.procInfo);
                }
                finally {
                    this.batch.clear();
                }
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] iterateBatch() throws SQLException {
        int[] nArray;
        boolean bl = this.hasByRefParam;
        this.hasByRefParam = false;
        LinkedList linkedList = this.batch;
        synchronized (linkedList) {
            int n = this.batch.size();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                try {
                    ParamSet paramSet = (ParamSet)this.batch.pollFirst();
                    if (this.trace.enabled()) {
                        this.trace.log(this.title + ".executeBatch[" + i + "] ");
                    }
                    if (paramSet == null) {
                        if (this.trace.enabled()) {
                            this.trace.log(this.title + ".executeBatch(): OUT parameters not allowed");
                        }
                        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
                    }
                    this.exec(paramSet);
                    int n2 = nArray[i] = (this.rslt_items & 0x20) != 0 ? this.rslt_val_proc : -2;
                    if (!this.trace.enabled()) continue;
                    this.trace.log(this.title + ".executeBatch[" + i + "] = " + nArray[i]);
                    continue;
                }
                catch (SQLException sQLException) {
                    int[] nArray2 = new int[i];
                    if (i > 0) {
                        System.arraycopy(nArray, 0, nArray2, 0, i);
                    }
                    BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
                    batchUpdateException.setNextException(sQLException.getNextException());
                    this.batch.clear();
                    this.hasByRefParam = bl;
                    throw batchUpdateException;
                }
            }
            this.batch.clear();
        }
        this.hasByRefParam = bl;
        return nArray;
    }

    private void exec(ParamSet paramSet) throws SQLException {
        this.clearResults();
        this.msg.lock();
        try {
            int n;
            String string = this.procInfo.getSchema();
            boolean bl = true;
            this.msg.begin((byte)4);
            this.msg.write((short)6);
            if (this.conn.msg_protocol_level >= 3) {
                n = 6;
                if (this.enableLocators(true)) {
                    n = (short)(n | 0x20);
                }
                this.msg.write((short)6);
                this.msg.write((short)2);
                this.msg.write((short)n);
                bl = false;
            }
            if (string != null) {
                this.msg.write((short)4);
                this.msg.write(string);
            }
            this.msg.write((short)5);
            this.msg.write(this.procInfo.getName());
            if (this.procInfo.getParamCount() < 1) {
                this.msg.done(true);
            } else {
                this.msg.done(false);
                paramSet.sendDesc(false);
                paramSet.sendData(true);
            }
            JdbcRSMD jdbcRSMD = this.readResults(this.timeout, bl);
            if (jdbcRSMD == null) {
                if (this.msg.moreMessages()) {
                    this.readResults(this.timeout, true);
                }
                this.msg.unlock();
            } else if (this.hasByRefParam) {
                this.resultRow = new RsltSlct(this.conn, this, jdbcRSMD, this.rslt_val_stmt, this.msg.moreMessages());
                int n2 = 1;
                for (n = 0; n < this.opMap.length; ++n) {
                    if (this.opMap[n] < 0) continue;
                    this.opMap[n] = n2++;
                }
            } else {
                this.resultSet = new RsltSlct(this.conn, (JdbcStmt)this, jdbcRSMD, this.rslt_val_stmt, this.getPreFetchSize(), this.msg.moreMessages());
            }
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".execute(): error executing procedure");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            this.msg.unlock();
            throw sQLException;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterMetaData()");
        }
        if (this.procQPMD == null) {
            try {
                this.procQPMD = new JdbcQPMD(this.conn, this.procInfo.getSchema(), this.procInfo.getName());
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ": error retrieving parameter info");
                }
                if (this.trace.enabled(1)) {
                    SqlExFactory.trace(sQLException, this.trace);
                }
                throw sQLException;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterMetaData(): " + this.procQPMD);
        }
        return this.procQPMD;
    }

    @Override
    protected synchronized void clearResults() {
        this.null_param = false;
        super.clearResults();
        if (this.resultRow != null) {
            try {
                this.resultRow.shut();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.resultRow = null;
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".clearParameters()");
        }
        super.clearParameters();
        this.initParameters();
    }

    @Override
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".registerOutParameter(" + n + "," + n2 + "," + n3 + ")");
        }
        if (this.isProcRslt(n)) {
            this.opType[this.opType.length - 1] = n2;
            this.opScale[this.opScale.length - 1] = n3;
        } else {
            int n4 = this.paramMap(n);
            this.opMap[n4] = 0;
            this.opType[n4] = n2;
            this.opScale[n4] = n3;
            this.hasByRefParam = true;
            if (!this.params.isSet(n4)) {
                this.params.setDefaultFlags((short)0);
                this.params.init(n4, 0);
                this.params.setNull(n4);
                this.params.setDefaultFlags((short)1);
            }
            this.params.setFlags(n4, (short)2);
        }
    }

    @Override
    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".registerOutParameter('" + string + "'," + n + "," + n2 + ")");
        }
        int n3 = this.findParam(string);
        this.opMap[n3] = 0;
        this.opType[n3] = n;
        this.opScale[n3] = n2;
        this.hasByRefParam = true;
        if (!this.params.isSet(n3)) {
            this.params.setDefaultFlags((short)0);
            this.params.init(n3, 0);
            this.params.setNull(n3);
            this.params.setDefaultFlags((short)1);
        }
        this.params.setFlags(n3, (short)2);
    }

    @Override
    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, -1);
    }

    @Override
    public void registerOutParameter(String string, int n) throws SQLException {
        this.registerOutParameter(string, n, -1);
    }

    @Override
    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.registerOutParameter(n, n2, -1);
    }

    @Override
    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.registerOutParameter(string, n, -1);
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setNull('" + string + "'," + n + (string2 == null ? ")" : ",'" + string2 + "')"));
        }
        int n2 = this.findParam(string);
        this.params.init(n2, n);
        this.params.setNull(n2);
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBoolean('" + string + "'," + bl + ")");
        }
        int n = this.findParam(string);
        this.params.init(n, 16);
        this.params.setBoolean(n, bl);
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setByte('" + string + "'," + by + ")");
        }
        int n = this.findParam(string);
        this.params.init(n, -6);
        this.params.setByte(n, by);
    }

    @Override
    public void setShort(String string, short s) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setShort('" + string + "'," + s + ")");
        }
        int n = this.findParam(string);
        this.params.init(n, 5);
        this.params.setShort(n, s);
    }

    @Override
    public void setInt(String string, int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + " setInt('" + string + "'," + n + ")");
        }
        int n2 = this.findParam(string);
        this.params.init(n2, 4);
        this.params.setInt(n2, n);
    }

    @Override
    public void setLong(String string, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setLong('" + string + "'," + l + ")");
        }
        int n = this.findParam(string);
        this.params.init(n, -5);
        this.params.setLong(n, l);
    }

    @Override
    public void setFloat(String string, float f) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setFloat('" + string + "'," + f + ")");
        }
        int n = this.findParam(string);
        this.params.init(n, 7);
        this.params.setFloat(n, f);
    }

    @Override
    public void setDouble(String string, double d) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setDouble('" + string + "'," + d + ")");
        }
        int n = this.findParam(string);
        this.params.init(n, 8);
        this.params.setDouble(n, d);
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBigDecimal('" + string + "'," + bigDecimal + ")");
        }
        int n = this.findParam(string);
        this.params.init(n, 3);
        this.params.setBigDecimal(n, bigDecimal);
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setString('" + string + "'," + string2 + ")");
        }
        int n = this.findParam(string);
        this.params.init(n, 12);
        this.params.setString(n, string2);
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBytes('" + string + "'," + (byArray == null ? "null" : "[" + byArray.length + "]") + ")");
        }
        int n = this.findParam(string);
        this.params.init(n, -3);
        this.params.setBytes(n, byArray);
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setDate('" + string + "'," + date + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        int n = this.findParam(string);
        this.params.init(n, 91);
        this.params.setDate(n, date, calendar == null ? null : calendar.getTimeZone());
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setTime('" + string + "'," + time + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        int n = this.findParam(string);
        this.params.init(n, 92);
        this.params.setTime(n, time, calendar == null ? null : calendar.getTimeZone());
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setTimestamp('" + string + "'," + timestamp + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        int n = this.findParam(string);
        this.params.init(n, 93);
        this.params.setTimestamp(n, timestamp, calendar == null ? null : calendar.getTimeZone());
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBinaryStream('" + string + "'," + l + ")");
        }
        int n = this.findParam(string);
        if (l >= 0L && l <= (long)this.conn.max_vbyt_len) {
            byte[] byArray = new byte[(int)l];
            try {
                int n2;
                int n3 = n2 = l > 0L ? inputStream.read(byArray) : 0;
                if ((long)n2 != l) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ".setBinaryStream: read only " + n2 + " of " + l + " bytes!");
                    }
                    this.setWarning(new DataTruncation(n, true, false, (int)l, n2));
                }
            }
            catch (IOException iOException) {
                throw SqlExFactory.get(ERR_GC4007_BLOB_IO);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.params.init(n, -3);
            this.params.setBytes(n, byArray);
        } else {
            this.params.init(n, -4);
            this.params.setBinaryStream(n, inputStream);
        }
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setAsciiStream('" + string + "'," + l + ")");
        }
        int n = this.findParam(string);
        if (l >= 0L && l <= (long)(this.conn.ucs2_supported ? this.conn.max_nvch_len : this.conn.max_vchr_len)) {
            char[] cArray = new char[(int)l];
            try {
                int n2;
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "US-ASCII");
                int n3 = n2 = l > 0L ? inputStreamReader.read(cArray) : 0;
                if ((long)n2 != l) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ".setCharacterStream: read only " + n2 + " of " + l + " characters!");
                    }
                    this.setWarning(new DataTruncation(n, true, false, (int)l, n2));
                }
            }
            catch (IOException iOException) {
                throw SqlExFactory.get(ERR_GC4007_BLOB_IO);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.params.init(n, 12);
            this.params.setString(n, new String(cArray));
        } else {
            this.params.init(n, -1);
            this.params.setAsciiStream(n, inputStream);
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setCharacterStream('" + string + "'," + l + ")");
        }
        int n = this.findParam(string);
        if (l >= 0L && l <= (long)(this.conn.ucs2_supported ? this.conn.max_nvch_len : this.conn.max_vchr_len)) {
            char[] cArray = new char[(int)l];
            try {
                int n2;
                int n3 = n2 = l > 0L ? reader.read(cArray) : 0;
                if ((long)n2 != l) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ".setCharacterStream: read only " + n2 + " of " + l + " characters!");
                    }
                    this.setWarning(new DataTruncation(n, true, false, (int)l, n2));
                }
            }
            catch (IOException iOException) {
                throw SqlExFactory.get(ERR_GC4007_BLOB_IO);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            this.params.init(n, 12);
            this.params.setString(n, new String(cArray));
        } else {
            this.params.init(n, -1);
            this.params.setCharacterStream(n, reader);
        }
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBlob('" + string + "'," + blob + ")");
        }
        int n = this.findParam(string);
        if (blob == null) {
            this.params.init(n, 2004);
            this.params.setNull(n);
        } else if (blob instanceof JdbcBlob && ((JdbcBlob)blob).isValidLocator(this.conn)) {
            DrvLOB drvLOB = ((JdbcBlob)blob).getLOB();
            this.params.init(n, drvLOB);
            if (drvLOB instanceof DrvBlob) {
                this.params.setBlob(n, (DrvBlob)drvLOB);
            } else {
                this.params.setBinaryStream(n, blob.getBinaryStream());
            }
        } else {
            this.params.init(n, -4);
            this.params.setBinaryStream(n, blob.getBinaryStream());
        }
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setClob('" + string + "'," + clob + ")");
        }
        int n = this.findParam(string);
        if (clob == null) {
            this.params.init(n, 2005);
            this.params.setNull(n);
        } else if (clob instanceof JdbcClob && ((JdbcClob)clob).isValidLocator(this.conn)) {
            DrvLOB drvLOB = ((JdbcClob)clob).getLOB();
            this.params.init(n, drvLOB);
            if (drvLOB instanceof DrvClob) {
                this.params.setClob(n, (DrvClob)drvLOB);
            } else if (drvLOB instanceof DrvNlob) {
                this.params.setClob(n, (DrvNlob)drvLOB);
            } else {
                this.params.setCharacterStream(n, clob.getCharacterStream());
            }
        } else {
            this.params.init(n, -1);
            this.params.setCharacterStream(n, clob.getCharacterStream());
        }
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setObject('" + string + " )");
        }
        if (object != null) {
            if (object instanceof Blob) {
                object = object instanceof JdbcBlob && ((JdbcBlob)object).isValidLocator(this.conn) ? ((JdbcBlob)object).getLOB() : ((Blob)object).getBinaryStream();
            } else if (object instanceof Clob) {
                object = object instanceof JdbcClob && ((JdbcClob)object).isValidLocator(this.conn) ? ((JdbcClob)object).getLOB() : ((Clob)object).getCharacterStream();
            }
        }
        int n = this.findParam(string);
        this.params.init(n, object);
        this.params.setObject(n, object);
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setObject('" + string + "'," + n + "," + n2 + ")");
        }
        if (object != null) {
            if (object instanceof Blob) {
                object = object instanceof JdbcBlob && ((JdbcBlob)object).isValidLocator(this.conn) ? ((JdbcBlob)object).getLOB() : ((Blob)object).getBinaryStream();
            } else if (object instanceof Clob) {
                object = object instanceof JdbcClob && ((JdbcClob)object).isValidLocator(this.conn) ? ((JdbcClob)object).getLOB() : ((Clob)object).getCharacterStream();
            }
        }
        int n3 = this.findParam(string);
        switch (n) {
            case 1111: {
                n = SqlData.getSqlType(object);
                this.params.init(n3, object, true);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                if (object != null && object instanceof String && ((String)object).length() == 0) {
                    this.params.init(n3, n, true);
                    break;
                }
                this.params.init(n3, n);
                break;
            }
            case -4: 
            case 2004: {
                if (object == null) {
                    this.params.init(n3, n);
                    break;
                }
                if (object instanceof DrvBlob) {
                    n = 2004;
                    this.params.init(n3, object);
                    break;
                }
                n = -4;
                this.params.init(n3, n);
                break;
            }
            case -1: 
            case 2005: {
                if (object == null) {
                    this.params.init(n3, n);
                    break;
                }
                if (object instanceof DrvClob || object instanceof DrvNlob) {
                    n = 2005;
                    this.params.init(n3, object);
                    break;
                }
                n = -1;
                this.params.init(n3, n);
                break;
            }
            default: {
                this.params.init(n3, n);
            }
        }
        this.params.setObject(n3, object, n, n2);
    }

    @Override
    public void setNull(String string, int n) throws SQLException {
        this.setNull(string, n, null);
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        this.setDate(string, date, null);
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        this.setTime(string, time, null);
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(string, timestamp, null);
    }

    @Override
    public void setObject(String string, Object object, int n) throws SQLException {
        this.setObject(string, object, n, 0);
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        this.setString(string, string2);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.setCharacterStream(string, reader, l);
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        this.setBinaryStream(string, inputStream, -1L);
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.setBinaryStream(string, inputStream, l);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(string, inputStream, (long)n);
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        this.setCharacterStream(string, reader, -1L);
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        this.setClob(string, (Clob)nClob);
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        this.setCharacterStream(string, reader, -1L);
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException {
        this.setCharacterStream(string, reader, l);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setAsciiStream(string, inputStream, (long)n);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.setCharacterStream(string, reader, (long)n);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.setAsciiStream(string, inputStream, -1L);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.setBinaryStream(string, inputStream, -1L);
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        this.setCharacterStream(string, reader, -1L);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        this.setCharacterStream(string, reader, -1L);
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException {
        this.setCharacterStream(string, reader, l);
    }

    public void setArray(String string, Array array) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setArray('" + string + "')");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    public void setRef(String string, Ref ref) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setRef('" + string + "')");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setURL('" + string + "')");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setSQLXML('" + string + "')");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setRowId('" + string + "')");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isWrapperFor(" + clazz + ")");
        }
        if (clazz != null) {
            return clazz.isInstance(this);
        }
        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".unwrap(" + clazz + ")");
        }
        if (clazz != null) {
            if (!clazz.isInstance(this)) {
                throw SqlExFactory.get(ERR_GC4023_NO_OBJECT);
            }
            return clazz.cast(this);
        }
        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".wasNull(): " + this.null_param);
        }
        return this.null_param;
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        boolean bl = false;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBoolean( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            bl = this.resultRow.getBoolean(this.resultMap(n));
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            bl = this.rslt_val_proc != 0;
            this.null_param = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBoolean: " + bl);
        }
        return bl;
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBoolean('" + string + "')");
        }
        boolean bl = this.resultRow.getBoolean(this.resultMap(string));
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBoolean: " + bl);
        }
        return bl;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        byte by = 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getByte( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            by = this.resultRow.getByte(this.resultMap(n));
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            by = (byte)this.rslt_val_proc;
            this.null_param = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getByte: " + by);
        }
        return by;
    }

    @Override
    public byte getByte(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getByte('" + string + "')");
        }
        byte by = this.resultRow.getByte(this.resultMap(string));
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getByte: " + by);
        }
        return by;
    }

    @Override
    public short getShort(int n) throws SQLException {
        short s = 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getShort( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            s = this.resultRow.getShort(this.resultMap(n));
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            s = (short)this.rslt_val_proc;
            this.null_param = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getShort: " + s);
        }
        return s;
    }

    @Override
    public short getShort(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getShort('" + string + "')");
        }
        short s = this.resultRow.getShort(this.resultMap(string));
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getShort: " + s);
        }
        return s;
    }

    @Override
    public int getInt(int n) throws SQLException {
        int n2 = 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getInt( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            n2 = this.resultRow.getInt(this.resultMap(n));
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            n2 = this.rslt_val_proc;
            this.null_param = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getInt: " + n2);
        }
        return n2;
    }

    @Override
    public int getInt(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getInt('" + string + "')");
        }
        int n = this.resultRow.getInt(this.resultMap(string));
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getInt: " + n);
        }
        return n;
    }

    @Override
    public long getLong(int n) throws SQLException {
        long l = 0L;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getLong( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            l = this.resultRow.getLong(this.resultMap(n));
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            l = this.rslt_val_proc;
            this.null_param = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getLong: " + l);
        }
        return l;
    }

    @Override
    public long getLong(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getLong('" + string + "')");
        }
        long l = this.resultRow.getLong(this.resultMap(string));
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getLong: " + l);
        }
        return l;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        float f = 0.0f;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFloat( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            f = this.resultRow.getFloat(this.resultMap(n));
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            f = this.rslt_val_proc;
            this.null_param = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFloat: " + f);
        }
        return f;
    }

    @Override
    public float getFloat(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFloat('" + string + "')");
        }
        float f = this.resultRow.getFloat(this.resultMap(string));
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFloat: " + f);
        }
        return f;
    }

    @Override
    public double getDouble(int n) throws SQLException {
        double d = 0.0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDouble( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            d = this.resultRow.getDouble(this.resultMap(n));
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            d = this.rslt_val_proc;
            this.null_param = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDouble: " + d);
        }
        return d;
    }

    @Override
    public double getDouble(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDouble('" + string + "')");
        }
        double d = this.resultRow.getDouble(this.resultMap(string));
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDouble: " + d);
        }
        return d;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBigDecimal( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            bigDecimal = this.resultRow.getBigDecimal(this.resultMap(n));
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            bigDecimal = BigDecimal.valueOf(this.rslt_val_proc);
            this.null_param = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBigDecimal: " + bigDecimal);
        }
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBigDecimal( " + n + ", " + n2 + " )");
        }
        if (!this.isProcRslt(n)) {
            bigDecimal = this.resultRow.getBigDecimal(this.resultMap(n), n2);
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            bigDecimal = BigDecimal.valueOf(this.rslt_val_proc);
            this.null_param = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBigDecimal: " + bigDecimal);
        }
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBigDecimal('" + string + "')");
        }
        BigDecimal bigDecimal = this.resultRow.getBigDecimal(this.resultMap(string));
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBigDecimal: " + bigDecimal);
        }
        return bigDecimal;
    }

    @Override
    public String getString(int n) throws SQLException {
        String string = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getString( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            string = this.resultRow.getString(this.resultMap(n));
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            string = Integer.toString(this.rslt_val_proc);
            if (this.rs_max_len > 0 && string.length() > this.rs_max_len) {
                string = string.substring(0, this.rs_max_len);
            }
            this.null_param = false;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getString: " + string);
        }
        return string;
    }

    @Override
    public String getString(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getString('" + string + "')");
        }
        String string2 = this.resultRow.getString(this.resultMap(string));
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getString: " + string2);
        }
        return string2;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        byte[] byArray = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBytes( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            byArray = this.resultRow.getBytes(this.resultMap(n));
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBytes: " + (byArray == null ? "null" : "[" + byArray.length + "]"));
        }
        return byArray;
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBytes('" + string + "')");
        }
        byte[] byArray = this.resultRow.getBytes(this.resultMap(string));
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBytes: " + (byArray == null ? "null" : "[" + byArray.length + "]"));
        }
        return byArray;
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDate( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            date = this.resultRow.getDate(this.resultMap(n), calendar);
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDate: " + date);
        }
        return date;
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDate('" + string + "')");
        }
        Date date = this.resultRow.getDate(this.resultMap(string), calendar);
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDate: " + date);
        }
        return date;
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTime( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            time = this.resultRow.getTime(this.resultMap(n), calendar);
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTime: " + time);
        }
        return time;
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTime('" + string + "')");
        }
        Time time = this.resultRow.getTime(this.resultMap(string), calendar);
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTime: " + time);
        }
        return time;
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTimestamp( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            timestamp = this.resultRow.getTimestamp(this.resultMap(n), calendar);
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTimestamp: " + timestamp);
        }
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTimestamp('" + string + "')");
        }
        Timestamp timestamp = this.resultRow.getTimestamp(this.resultMap(string), calendar);
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTimestamp: " + timestamp);
        }
        return timestamp;
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        Blob blob = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBlob( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            blob = this.resultRow.getBlob(this.resultMap(n));
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBlob: " + blob);
        }
        return blob;
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBlob('" + string + "')");
        }
        Blob blob = this.resultRow.getBlob(this.resultMap(string));
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBlob: " + blob);
        }
        return blob;
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        Clob clob = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getClob( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            clob = this.resultRow.getClob(this.resultMap(n));
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getClob: " + clob);
        }
        return clob;
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getClob('" + string + "')");
        }
        Clob clob = this.resultRow.getClob(this.resultMap(string));
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getClob: " + clob);
        }
        return clob;
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        NClob nClob = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getNClob( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            nClob = this.resultRow.getNClob(this.resultMap(n));
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getNClob: " + nClob);
        }
        return nClob;
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getNClob('" + string + "')");
        }
        NClob nClob = this.resultRow.getNClob(this.resultMap(string));
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getNClob: " + nClob);
        }
        return nClob;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        Object object = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getObject( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            object = this.getObject(this.resultRow, this.resultMap(n));
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            this.null_param = false;
            switch (this.opType[this.opType.length - 1]) {
                case -7: 
                case 16: {
                    object = this.rslt_val_proc != 0;
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    object = this.rslt_val_proc;
                    break;
                }
                case -5: {
                    object = (long)this.rslt_val_proc;
                    break;
                }
                case 7: {
                    object = Float.valueOf(this.rslt_val_proc);
                    break;
                }
                case 6: 
                case 8: {
                    object = (double)this.rslt_val_proc;
                    break;
                }
                case 2: 
                case 3: {
                    int n2 = this.opScale[this.opScale.length - 1];
                    if (n2 < 0) {
                        object = BigDecimal.valueOf(this.rslt_val_proc);
                        break;
                    }
                    object = BigDecimal.valueOf(this.rslt_val_proc, n2);
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    object = Integer.toString(this.rslt_val_proc);
                    break;
                }
                default: {
                    throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
                }
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getObject: " + object);
        }
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getObject('" + string + "')");
        }
        Object object = this.getObject(this.resultRow, this.resultMap(string));
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getObject: " + object);
        }
        return object;
    }

    private Object getObject(ResultSet resultSet, int n) throws SQLException {
        Object object;
        int n2 = this.unMap(n);
        switch (this.opType[n2]) {
            case -7: 
            case 16: {
                object = resultSet.getBoolean(n);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                object = resultSet.getInt(n);
                break;
            }
            case -5: {
                object = resultSet.getLong(n);
                break;
            }
            case 7: {
                object = Float.valueOf(resultSet.getFloat(n));
                break;
            }
            case 6: 
            case 8: {
                object = resultSet.getDouble(n);
                break;
            }
            case 2: 
            case 3: {
                int n3 = this.opScale[n2];
                if (n3 < 0) {
                    object = resultSet.getBigDecimal(n);
                    break;
                }
                object = resultSet.getBigDecimal(n, n3);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                object = resultSet.getString(n);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = resultSet.getBytes(n);
                break;
            }
            case 91: {
                object = resultSet.getDate(n);
                break;
            }
            case 92: {
                object = resultSet.getTime(n);
                break;
            }
            case 93: {
                object = resultSet.getTimestamp(n);
                break;
            }
            case 2004: {
                object = resultSet.getBlob(n);
                break;
            }
            case 2005: {
                object = resultSet.getClob(n);
                break;
            }
            default: {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
        this.null_param = resultSet.wasNull();
        return this.null_param ? null : object;
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        Reader reader = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCharacterStream( " + n + " )");
        }
        if (!this.isProcRslt(n)) {
            reader = this.resultRow.getCharacterStream(this.resultMap(n));
            this.null_param = this.resultRow.wasNull();
        } else if ((this.rslt_items & 0x20) == 0) {
            this.null_param = true;
        } else {
            throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCharacterStream: " + reader);
        }
        return reader;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCharacterStream('" + string + "')");
        }
        Reader reader = this.resultRow.getCharacterStream(this.resultMap(string));
        this.null_param = this.resultRow.wasNull();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCharacterStream: " + reader);
        }
        return reader;
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return this.getDate(n, null);
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(string, null);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return this.getTime(n, null);
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(string, null);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, null);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(string, null);
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(string);
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getString(string);
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.getCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(string);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getArray( " + n + " )");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getArray('" + string + "')");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getRef( " + n + " )");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getRef('" + string + "')");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getURL( " + n + " )");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getURL('" + string + "')");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSQLXML( " + n + " )");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSQLXML('" + string + "')");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getRowId( " + n + " )");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getRowId('" + string + "')");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    private boolean isProcRslt(int n) {
        return this.procRsltIndex > 0 && n == this.procRsltIndex;
    }

    private synchronized void checkParams(ParamSet paramSet) throws SQLException {
        int n;
        int n2 = this.procInfo.getParamCount();
        for (n = 0; n < n2; ++n) {
            if (this.procInfo.getParamType(n) == 0 || paramSet.isSet(n)) continue;
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": parameter not set: " + (n + 1));
            }
            throw SqlExFactory.get(ERR_GC4020_NO_PARAM);
        }
        if (this.access_type == 1 && !this.procInfo.paramNamesLoaded() && this.conn.db_protocol_level < 6) {
            this.procInfo.loadParamNames();
            for (n = 0; n < n2; ++n) {
                paramSet.setName(n, this.procInfo.getParamName(n));
            }
        }
    }

    private synchronized int findParam(String string) throws SQLException {
        if (string == null) {
            throw SqlExFactory.get(ERR_GC4012_INVALID_COLUMN_NAME);
        }
        switch (this.access_type) {
            case 2: {
                break;
            }
            case 0: {
                this.access_type = 2;
                break;
            }
            default: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".findParam(): mixed access by name & index");
                }
                throw SqlExFactory.get(ERR_GC4012_INVALID_COLUMN_NAME);
            }
        }
        int n = -1;
        for (int i = 0; i < this.dpMap.length; ++i) {
            if (this.dpMap[i] < 0) continue;
            int n2 = this.dpMap[i];
            String string2 = this.params.getName(n2);
            if (string2 == null) {
                n = n < 0 ? n2 : n;
                continue;
            }
            if (!string.equalsIgnoreCase(string2)) continue;
            if (this.trace.enabled(5)) {
                this.trace.write(this.tr_id + ".findParam(): matched '" + string + "' to index " + this.dpMap[i]);
            }
            return n2;
        }
        if (n >= 0) {
            if (this.trace.enabled(5)) {
                this.trace.write(this.tr_id + ".findParam(): assigned '" + string + "' to index " + n);
            }
            this.params.setName(n, string);
            return n;
        }
        if (this.trace.enabled(1)) {
            this.trace.write(this.tr_id + ".findParam(): no unassigned dynamic parameters: '" + string + "'");
        }
        throw SqlExFactory.get(ERR_GC4012_INVALID_COLUMN_NAME);
    }

    @Override
    protected synchronized int paramMap(int n) throws SQLException {
        switch (this.access_type) {
            case 1: {
                break;
            }
            case 0: {
                this.access_type = 1;
                break;
            }
            default: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".paramMap(): mixed access by name & index");
                }
                throw SqlExFactory.get(ERR_GC4011_INDEX_RANGE);
            }
        }
        if (--n < 0 || n >= this.dpMap.length || this.dpMap[n] < 0) {
            throw SqlExFactory.get(ERR_GC4011_INDEX_RANGE);
        }
        return this.dpMap[n];
    }

    private int resultMap(int n) throws SQLException {
        if (this.resultRow == null || --n < 0 || n >= this.dpMap.length || this.dpMap[n] < 0 || this.opMap[this.dpMap[n]] < 0 || this.opMap[this.dpMap[n]] > this.resultRow.getMetaData().getColumnCount()) {
            throw SqlExFactory.get(ERR_GC4011_INDEX_RANGE);
        }
        return this.opMap[this.dpMap[n]];
    }

    private int resultMap(String string) throws SQLException {
        if (string == null || this.resultRow == null) {
            throw SqlExFactory.get(ERR_GC4012_INVALID_COLUMN_NAME);
        }
        for (int i = 0; i < this.dpMap.length; ++i) {
            int n;
            String string2;
            if (this.dpMap[i] < 0 || (string2 = this.params.getName(n = this.dpMap[i])) == null || !string.equalsIgnoreCase(string2)) continue;
            if (this.opMap[n] < 0 || this.opMap[n] > this.resultRow.getMetaData().getColumnCount()) {
                throw SqlExFactory.get(ERR_GC4012_INVALID_COLUMN_NAME);
            }
            return this.opMap[n];
        }
        throw SqlExFactory.get(ERR_GC4012_INVALID_COLUMN_NAME);
    }

    private int unMap(int n) throws SQLException {
        for (int i = 0; i < this.opMap.length; ++i) {
            if (n != this.opMap[i]) continue;
            return i;
        }
        throw SqlExFactory.get(ERR_GC4011_INDEX_RANGE);
    }

    protected static class BatchExec
    extends JdbcStmt.BatchExec {
        public BatchExec(DrvConn drvConn) {
            super(drvConn);
        }

        public int[] execute(LinkedList linkedList, ProcInfo procInfo) throws SQLException {
            if (linkedList == null || linkedList.peekFirst() == null) {
                return noResults;
            }
            this.clearResults();
            this.msg.lock();
            try {
                ParamSet paramSet;
                String string = procInfo.getSchema();
                String string2 = procInfo.getName();
                boolean bl = true;
                int n = 0;
                while ((paramSet = (ParamSet)linkedList.pollFirst()) != null) {
                    byte by;
                    int n2 = paramSet.getCount();
                    byte by2 = by = linkedList.peekFirst() == null ? (byte)2 : 4;
                    if (this.trace.enabled()) {
                        this.trace.log(this.title + ".executeBatch[" + n + "]");
                    }
                    ++n;
                    this.msg.begin((byte)12);
                    this.msg.write((short)6);
                    if (bl) {
                        if (string != null) {
                            this.msg.write((short)4);
                            this.msg.write(string);
                        }
                        this.msg.write((short)5);
                        this.msg.write(string2);
                        bl = false;
                    } else {
                        this.msg.write((short)6);
                        this.msg.write((short)2);
                        this.msg.write((short)128);
                    }
                    if (n2 <= 0) {
                        this.msg.done(by);
                        continue;
                    }
                    this.msg.done(false);
                    paramSet.sendDesc(false);
                    paramSet.sendData(by);
                }
                this.readResults(n);
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".execute(): error executing batch");
                }
                if (this.trace.enabled(1)) {
                    SqlExFactory.trace(sQLException, this.trace);
                }
                throw sQLException;
            }
            finally {
                this.msg.unlock();
            }
            return this.batchResults();
        }

        @Override
        protected int getQueryResult() {
            if ((this.rslt_items & 0x20) != 0) {
                this.rslt_items &= 0xFFFFFFDF;
                return this.rslt_val_proc;
            }
            return super.getQueryResult();
        }
    }
}

