/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.manager;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.internal.CentralStore;
import com.ibm.db2.cmx.runtime.internal.CentralStoreKey;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryDataFactory;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryVersionImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.CurrentSchemaReader;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.CurrentSchemaWriter;
import com.ibm.db2.cmx.runtime.internal.repository.sql.AsyncRefreshMaintenance;
import com.ibm.db2.cmx.runtime.internal.repository.sql.db2.DB2AsyncRefreshMaintenance;
import com.ibm.db2.cmx.runtime.internal.repository.sql.generic.GenericAsyncRefreshMaintenance;
import com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk2.AccessMetaDataAppl;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionManager {
    private static Map<Integer, ConnectionInfo> stateMap = new HashMap<Integer, ConnectionInfo>();

    public static ConnectionType getConnectionType(Connection connection) {
        ConnectionType connectionType = ConnectionType.Other;
        try {
            String string = connection.getMetaData().getDatabaseProductName().toUpperCase();
            if (string.contains("DB2") || string.equals("AS")) {
                connectionType = ConnectionType.DB2;
            } else if (string.contains("DERBY")) {
                connectionType = ConnectionType.Derby;
            } else if (string.contains("ORACLE")) {
                connectionType = ConnectionType.Oracle;
            } else if (string.startsWith("INFORMIX") || string.startsWith("IDS")) {
                connectionType = ConnectionType.Informix;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return connectionType;
    }

    public static RepositoryVersion prepareConnection(Connection connection, boolean bl2, String string) throws SQLException, MetadataException {
        Object object;
        boolean bl3;
        Logger logger = Log.getLogger();
        boolean bl4 = bl3 = logger != null && logger.isLoggable(Level.FINE);
        if (bl3) {
            object = "Preparing connection " + connection + " getRepositoryVersion " + bl2;
            logger.logp(Level.FINE, "ConnectionManager", "prepareConnection", (String)object);
        }
        object = new ConnectionInfo();
        ((ConnectionInfo)object).origAutoCommit = connection.getAutoCommit();
        ((ConnectionInfo)object).origSchemaName = CurrentSchemaReader.getCurrentSchema(connection);
        if (!ConnectionManager.isSchemaValid(((ConnectionInfo)object).origSchemaName, connection, string)) {
            try {
                CurrentSchemaWriter.setCurrentSchema(connection, string);
                ((ConnectionInfo)object).setSchemaName = true;
                ((ConnectionInfo)object).currentSchemaName = string;
            }
            catch (Exception exception) {
                try {
                    CurrentSchemaWriter.setCurrentSchema(connection, "DB2PM");
                }
                catch (MetadataException metadataException) {
                    // empty catch block
                }
                ((ConnectionInfo)object).setSchemaName = true;
                ((ConnectionInfo)object).currentSchemaName = "DB2PM";
            }
        } else {
            ((ConnectionInfo)object).setSchemaName = false;
            ((ConnectionInfo)object).currentSchemaName = ((ConnectionInfo)object).origSchemaName;
        }
        RepositoryVersion repositoryVersion = null;
        if (bl2) {
            repositoryVersion = ConnectionManager.determineVersionAndExecutionMode((ConnectionInfo)object, connection);
        } else {
            ((ConnectionInfo)object).pureQueryAccessMode = "DYNAMIC";
        }
        Integer n2 = System.identityHashCode(connection);
        stateMap.put(n2, (ConnectionInfo)object);
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            if (bl3) {
                String string2 = "Error in prepareConnection";
                logger.logp(Level.FINE, "ConnectionManager", "prepareConnection", string2, sQLException);
            }
            throw sQLException;
        }
        if (bl3) {
            String string3 = "Modified connection.  Stored under hashcode " + n2 + " origAutoCommit=" + ((ConnectionInfo)object).origAutoCommit + "  origSchemaName " + ((ConnectionInfo)object).origSchemaName + " setSchemaName " + ((ConnectionInfo)object).setSchemaName;
            logger.logp(Level.FINE, "ConnectionManager", "prepareConnection", string3);
        }
        return repositoryVersion;
    }

    public static RepositoryVersion prepareConnection(Connection connection, CentralStoreKey centralStoreKey) throws SQLException, MetadataException {
        Object object;
        Object object2;
        Object object3;
        RepositoryVersion repositoryVersion;
        String string;
        Object object4;
        boolean bl2;
        Logger logger = Log.getLogger();
        boolean bl3 = bl2 = logger != null && logger.isLoggable(Level.FINE);
        if (bl2) {
            object4 = "Preparing connection " + connection + " CentralStoreKey " + centralStoreKey;
            logger.logp(Level.FINE, "ConnectionManager", "prepareConnection", (String)object4);
        }
        object4 = new ConnectionInfo();
        ((ConnectionInfo)object4).origAutoCommit = connection.getAutoCommit();
        ((ConnectionInfo)object4).origSchemaName = CurrentSchemaReader.getCurrentSchema(connection);
        String string2 = centralStoreKey.getRepositorySchema();
        if (string2 == null && (string2 = DataProperties.getProperty("pdq.repositorySchema")) == null) {
            string2 = "IBMPDQ";
        }
        if ((string = connection.getMetaData().getDatabaseProductName().toUpperCase()).contains("DB2")) {
            if (string2 != null && !string2.equals("IBMPDQ")) {
                CentralStore.repositoryPackageName_.set(string2);
            } else {
                CentralStore.repositoryPackageName_.set(null);
            }
        }
        if (!ConnectionManager.isSchemaValid(((ConnectionInfo)object4).origSchemaName, connection, string2)) {
            try {
                CurrentSchemaWriter.setCurrentSchema(connection, string2);
                ((ConnectionInfo)object4).setSchemaName = true;
                ((ConnectionInfo)object4).currentSchemaName = string2;
            }
            catch (Exception exception) {
                try {
                    CurrentSchemaWriter.setCurrentSchema(connection, "DB2PM");
                }
                catch (MetadataException metadataException) {
                    // empty catch block
                }
                ((ConnectionInfo)object4).setSchemaName = true;
                ((ConnectionInfo)object4).currentSchemaName = "DB2PM";
            }
        } else {
            ((ConnectionInfo)object4).setSchemaName = false;
            ((ConnectionInfo)object4).currentSchemaName = ((ConnectionInfo)object4).origSchemaName;
        }
        if ((repositoryVersion = centralStoreKey.getRepositoryVersion()) == null) {
            repositoryVersion = ConnectionManager.determineVersionAndExecutionMode((ConnectionInfo)object4, connection);
            centralStoreKey.setRepositoryVersion(repositoryVersion);
            centralStoreKey.setRepositoryConnecticnInfo((ConnectionInfo)object4);
            if (centralStoreKey.getCompareToRV_2_2_7() >= 0) {
                object3 = connection.getMetaData().getDatabaseProductName().toUpperCase();
                object2 = null;
                object2 = ((String)object3).contains("DB2") || ((String)object3).equals("AS") ? (AsyncRefreshMaintenance)RepositoryDataFactory.getData(DB2AsyncRefreshMaintenance.class, connection, (ConnectionInfo)object4) : (AsyncRefreshMaintenance)RepositoryDataFactory.getData(GenericAsyncRefreshMaintenance.class, connection, (ConnectionInfo)object4);
                object = object2.getMetadataGroupMaxRefresh();
                if (object == null) {
                    object = 0;
                }
                centralStoreKey.setRepositoryAsyncRefreshTrack((Integer)object);
                List<Map<String, Object>> list = object2.getRepositoryUUID();
                Map<String, Object> map = list.get(0);
                Long l2 = (Long)map.get("uuid_most_significant_bits");
                Long l3 = (Long)map.get("uuid_least_significant_bits");
                if (l2 == null && l3 == null || l2 != null && l2 == 0L && l3 != null && l3 == 0L) {
                    UUID uUID = UUID.randomUUID();
                    l2 = uUID.getMostSignificantBits();
                    int n2 = object2.setRepositoryUUID(l2, l3 = Long.valueOf(uUID.getLeastSignificantBits()));
                    if (n2 == 0) {
                        list = object2.getRepositoryUUID();
                        map = list.get(0);
                        l2 = (Long)map.get("uuid_most_significant_bits");
                        l3 = (Long)map.get("uuid_least_significant_bits");
                    }
                    centralStoreKey.setRepositoryUUID(l2, l3);
                }
            }
        } else {
            ((ConnectionInfo)object4).pureQueryAccessMode = centralStoreKey.getRepositoryConnecticnInfo().pureQueryAccessMode;
            centralStoreKey.setRepositoryConnecticnInfo((ConnectionInfo)object4);
        }
        object3 = System.identityHashCode(connection);
        stateMap.put((Integer)object3, (ConnectionInfo)object4);
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            if (bl2) {
                object = "Error in prepareConnection";
                logger.logp(Level.FINE, "ConnectionManager", "prepareConnection", (String)object, sQLException);
            }
            throw sQLException;
        }
        if (bl2) {
            object2 = "Modified connection.  Stored under hashcode " + object3 + " origAutoCommit=" + ((ConnectionInfo)object4).origAutoCommit + "  origSchemaName " + ((ConnectionInfo)object4).origSchemaName + " setSchemaName " + ((ConnectionInfo)object4).setSchemaName;
            logger.logp(Level.FINE, "ConnectionManager", "prepareConnection", (String)object2);
        }
        return repositoryVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RepositoryVersion determineVersionAndExecutionMode(ConnectionInfo connectionInfo, Connection connection) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Writer writer;
        Object object5;
        List<Map<String, Object>> list;
        String string;
        boolean bl2;
        Logger logger;
        block20: {
            logger = Log.getLogger();
            bl2 = logger != null && logger.isLoggable(Level.FINE);
            string = null;
            list = null;
            try {
                string = connection.getMetaData().getDatabaseProductName().toUpperCase();
            }
            catch (SQLException sQLException) {
                if (!bl2) break block20;
                object5 = new StringWriter();
                writer = new PrintWriter((Writer)object5, true);
                sQLException.printStackTrace((PrintWriter)writer);
                ((PrintWriter)writer).flush();
                object4 = "Cannot determine product name from metadata\n" + ((StringWriter)object5).toString();
                logger.logp(Level.FINE, "ConnectionManager", "determineVersionAndExecutionMode", (String)object4);
            }
        }
        try {
            if (string != null && !string.contains("DB2") && !string.equals("AS")) {
                connectionInfo.pureQueryAccessMode = "DYNAMIC";
                object3 = RepositoryDataFactory.getData(AccessMetaDataAppl.class, connection, connectionInfo);
                list = object3.getRU();
            } else {
                connectionInfo.pureQueryAccessMode = "STATIC";
                object3 = RepositoryDataFactory.getData(AccessMetaDataAppl.class, connection, connectionInfo);
                list = object3.getRU();
                connectionInfo.pureQueryAccessMode = "STATIC";
            }
        }
        catch (DataRuntimeException dataRuntimeException) {
            if (ConnectionManager.isPackageNotFound(dataRuntimeException) || ConnectionManager.isNotAuthorized(dataRuntimeException) || ConnectionManager.isPackageUnavailable(dataRuntimeException) || ConnectionManager.isTimestampConflict(dataRuntimeException) || ConnectionManager.isBlankCurrentPackageset(dataRuntimeException)) {
                try {
                    connectionInfo.pureQueryAccessMode = "DYNAMIC";
                    object5 = RepositoryDataFactory.getData(AccessMetaDataAppl.class, connection, connectionInfo);
                    list = object5.getRU();
                }
                catch (DataRuntimeException dataRuntimeException2) {
                    if (bl2) {
                        writer = new StringWriter();
                        object4 = new PrintWriter(writer, true);
                        object2 = dataRuntimeException2;
                        if (dataRuntimeException2.getCause() != null && dataRuntimeException2.getCause() instanceof SQLException) {
                            object2 = dataRuntimeException2.getCause();
                        }
                        ((Throwable)object2).printStackTrace((PrintWriter)object4);
                        ((PrintWriter)object4).flush();
                        object = "Caught Data Runtime Exception while using dynamic API\n" + ((StringWriter)writer).toString();
                        logger.logp(Level.FINE, "ConnectionManager", "determineVersionAndExecutionMode", (String)object);
                    }
                }
            } else if (bl2) {
                object5 = new StringWriter();
                writer = new PrintWriter((Writer)object5, true);
                object4 = dataRuntimeException;
                if (dataRuntimeException.getCause() != null && dataRuntimeException.getCause() instanceof SQLException) {
                    object4 = dataRuntimeException.getCause();
                }
                ((Throwable)object4).printStackTrace((PrintWriter)writer);
                ((PrintWriter)writer).flush();
                object2 = "Caught Data Runtime Exception while using static API\n" + ((StringWriter)object5).toString();
                logger.logp(Level.FINE, "ConnectionManager", "determineVersionAndExecutionMode", (String)object2);
            }
            connectionInfo.pureQueryAccessMode = "DYNAMIC";
        }
        if (list == null) {
            return null;
        }
        object3 = null;
        try {
            int n2 = list.size();
            for (int i10 = 0; i10 < n2; ++i10) {
                object4 = list.get(i10);
                object2 = (Number)object4.get("version");
                object = (Number)object4.get("release");
                Number number = (Number)object4.get("mod");
                object3 = new RepositoryVersionImpl((String)object4.get("component"), object2 != null ? ((Number)object2).intValue() : -1, object != null ? ((Number)object).intValue() : -1, number != null ? number.intValue() : -1);
            }
        }
        catch (Throwable throwable) {
        }
        return object3;
    }

    private static boolean isPackageUnavailable(DataRuntimeException dataRuntimeException) {
        if (dataRuntimeException.getCause() != null && dataRuntimeException.getCause() instanceof SQLException) {
            SQLException sQLException = (SQLException)dataRuntimeException.getCause();
            boolean bl2 = "57011".equalsIgnoreCase(sQLException.getSQLState());
            if (bl2) {
                boolean bl3;
                Logger logger = Log.getLogger();
                boolean bl4 = bl3 = logger != null && logger.isLoggable(Level.FINE);
                if (bl3) {
                    String string = "Package not available";
                    logger.logp(Level.FINE, "RepositoryVersionImpl", "isPackageUnavailable", string);
                }
            }
            return bl2;
        }
        return false;
    }

    private static boolean isNotAuthorized(DataRuntimeException dataRuntimeException) {
        if (dataRuntimeException.getCause() != null && dataRuntimeException.getCause() instanceof SQLException) {
            SQLException sQLException = (SQLException)dataRuntimeException.getCause();
            boolean bl2 = "42501".equalsIgnoreCase(sQLException.getSQLState());
            if (bl2) {
                boolean bl3;
                Logger logger = Log.getLogger();
                boolean bl4 = bl3 = logger != null && logger.isLoggable(Level.FINE);
                if (bl3) {
                    String string = "Not authorized";
                    logger.logp(Level.FINE, "RepositoryVersionImpl", "isNotAuthorized", string);
                }
            }
            return bl2;
        }
        return false;
    }

    private static boolean isTimestampConflict(DataRuntimeException dataRuntimeException) {
        if (dataRuntimeException.getCause() != null && dataRuntimeException.getCause() instanceof SQLException) {
            SQLException sQLException = (SQLException)dataRuntimeException.getCause();
            boolean bl2 = "51003".equalsIgnoreCase(sQLException.getSQLState());
            if (bl2) {
                boolean bl3;
                Logger logger = Log.getLogger();
                boolean bl4 = bl3 = logger != null && logger.isLoggable(Level.FINE);
                if (bl3) {
                    String string = "Timestamp conflict";
                    logger.logp(Level.FINE, "RepositoryVersionImpl", "isTimestampConflict", string);
                }
            }
            return bl2;
        }
        return false;
    }

    private static boolean isPackageNotFound(DataRuntimeException dataRuntimeException) {
        if (dataRuntimeException.getCause() != null && dataRuntimeException.getCause() instanceof SQLException) {
            SQLException sQLException = (SQLException)dataRuntimeException.getCause();
            boolean bl2 = "51002".equalsIgnoreCase(sQLException.getSQLState());
            if (bl2) {
                boolean bl3;
                Logger logger = Log.getLogger();
                boolean bl4 = bl3 = logger != null && logger.isLoggable(Level.FINE);
                if (bl3) {
                    String string = "Package not found";
                    logger.logp(Level.FINE, "RepositoryVersionImpl", "isPackageNotFound", string);
                }
            }
            return bl2;
        }
        return false;
    }

    private static boolean isBlankCurrentPackageset(DataRuntimeException dataRuntimeException) {
        if (dataRuntimeException.getCause() != null && dataRuntimeException.getCause() instanceof SQLException) {
            SQLException sQLException = (SQLException)dataRuntimeException.getCause();
            boolean bl2 = "22508".equalsIgnoreCase(sQLException.getSQLState());
            if (bl2) {
                boolean bl3;
                Logger logger = Log.getLogger();
                boolean bl4 = bl3 = logger != null && logger.isLoggable(Level.FINE);
                if (bl3) {
                    String string = "A blank Collection-ID was found in the CURRENT PACKAGESET special register";
                    logger.logp(Level.FINE, "RepositoryVersionImpl", "isBlankCurrentPackageset", string);
                }
            }
            return bl2;
        }
        return false;
    }

    public static void restoreConnection(Connection connection) throws SQLException, MetadataException {
        String string;
        boolean bl2;
        Integer n2 = System.identityHashCode(connection);
        ConnectionInfo connectionInfo = stateMap.remove(n2);
        Logger logger = Log.getLogger();
        boolean bl3 = bl2 = logger != null && logger.isLoggable(Level.FINE);
        if (bl2) {
            string = "Restoring connection " + connection + " for hashcode key " + n2;
            string = connectionInfo != null ? string + "  origAutoCommit=" + connectionInfo.origAutoCommit + "  origSchemaName " + connectionInfo.origSchemaName + " setSchemaName " + connectionInfo.setSchemaName : string + ".  No ConnectionInfo object stored.";
            logger.logp(Level.FINE, "ConnectionManager", "restoreConnection", string);
        }
        if (connectionInfo != null) {
            try {
                if (connectionInfo.setSchemaName && connectionInfo.origSchemaName != null) {
                    CurrentSchemaWriter.setCurrentSchema(connection, connectionInfo.origSchemaName);
                    connection.commit();
                }
                connection.setAutoCommit(connectionInfo.origAutoCommit);
            }
            catch (MetadataException metadataException) {
                if (bl2) {
                    String string2 = "Error in restoreConnection";
                    logger.logp(Level.FINE, "ConnectionManager", "restoreConnection", string2, metadataException);
                }
                throw metadataException;
            }
            catch (SQLException sQLException) {
                if (bl2) {
                    String string3 = "Error in restoreConnection";
                    logger.logp(Level.FINE, "ConnectionManager", "restoreConnection", string3, sQLException);
                }
                throw sQLException;
            }
        }
        if (bl2) {
            string = "Restore connection finished successfully";
            logger.logp(Level.FINE, "ConnectionManager", "restoreConnection", string);
        }
    }

    private static boolean isSchemaValid(String string, Connection connection, String string2) {
        return string2.equals(string) || "DB2PM".equals(string);
    }

    public static ConnectionInfo getConnectionInfo(Connection connection) {
        return stateMap.get(System.identityHashCode(connection));
    }

    public static class ConnectionInfo {
        public String origSchemaName = null;
        public boolean origAutoCommit = true;
        public boolean setSchemaName = false;
        public String currentSchemaName = null;
        public String pureQueryAccessMode = null;
    }

    public static enum ConnectionType {
        DB2,
        Derby,
        Informix,
        Oracle,
        Other;

    }
}

