/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.base;

import com.dbeaver.jdbc.base.AbstractJdbcConnection;
import com.dbeaver.jdbc.base.AbstractJdbcResultSetMetaData;
import com.dbeaver.jdbc.base.AbstractJdbcStatement;
import java.sql.SQLException;
import java.util.function.Function;

public class CachedJdbcResultSetMetaData<STMT extends AbstractJdbcStatement<? extends AbstractJdbcConnection>, OBJECT_TYPE>
extends AbstractJdbcResultSetMetaData<STMT> {
    private final ColumnInfo<OBJECT_TYPE>[] columns;

    public CachedJdbcResultSetMetaData(STMT statement, ColumnInfo<OBJECT_TYPE>[] columns) {
        super(statement);
        this.columns = columns;
    }

    ColumnInfo<OBJECT_TYPE>[] getColumns() {
        return this.columns;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columns.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columns[column - 1].label;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columns[column - 1].name;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return null;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.columns[column - 1].tableName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return null;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.columns[column - 1].type;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.columns[column - 1].typeName;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    public static class ColumnInfo<TYPE> {
        private final String name;
        private final int type;
        private String typeName;
        public String tableName;
        private final String label;
        private final Function<TYPE, Object> reader;

        public ColumnInfo(String name, String label, int type, Function<TYPE, Object> reader) {
            this.name = name;
            this.type = type;
            this.label = label;
            this.reader = reader;
        }

        public ColumnInfo(String name, String label, int type, String typeName, String tableName, Function<TYPE, Object> reader) {
            this.name = name;
            this.label = label;
            this.type = type;
            this.typeName = typeName;
            this.tableName = tableName;
            this.reader = reader;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public String getLabel() {
            return this.label;
        }

        public Function<TYPE, Object> getReader() {
            return this.reader;
        }

        public String toString() {
            return this.name;
        }
    }
}

