/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.base;

import com.dbeaver.jdbc.base.AbstractJdbcConnection;
import com.dbeaver.jdbc.base.AbstractJdbcResultSet;
import com.dbeaver.jdbc.base.AbstractJdbcStatement;
import com.dbeaver.jdbc.base.CachedJdbcResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.jkiss.utils.CommonUtils;

public class CachedJdbcResultSet<STMT extends AbstractJdbcStatement<? extends AbstractJdbcConnection>, META extends CachedJdbcResultSetMetaData<STMT, OBJECT_TYPE>, OBJECT_TYPE>
extends AbstractJdbcResultSet<STMT, META> {
    private static final SimpleDateFormat TIME_FORMAT_LONG = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final SimpleDateFormat TIME_FORMAT_SHORT = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat TIMESTAMP_FORMAT_LONG = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final SimpleDateFormat TIMESTAMP_FORMAT_SHORT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private OBJECT_TYPE[] rows;
    private int index = -1;

    public CachedJdbcResultSet(STMT statement, META metadata, OBJECT_TYPE[] rows) {
        super(statement, metadata);
        this.rows = rows;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            return ((CachedJdbcResultSetMetaData)this.metadata).getColumns()[columnIndex - 1].getReader().apply(this.rows[this.index]);
        }
        catch (RuntimeException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        CachedJdbcResultSetMetaData.ColumnInfo<OBJECT_TYPE>[] columns = ((CachedJdbcResultSetMetaData)this.metadata).getColumns();
        int i = 0;
        while (i < columns.length) {
            CachedJdbcResultSetMetaData.ColumnInfo ci = columns[i];
            if (columnLabel.equals(ci.getName())) {
                return i + 1;
            }
            ++i;
        }
        throw new SQLException("Column '" + columnLabel + "' not found in result set");
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return CommonUtils.toString((Object)this.getObject(columnIndex), null);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return CommonUtils.toBoolean((Object)this.getObject(columnIndex));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return (byte)CommonUtils.toInt((Object)this.getObject(columnIndex));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return (short)CommonUtils.toInt((Object)this.getObject(columnIndex));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return CommonUtils.toInt((Object)this.getObject(columnIndex));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return CommonUtils.toLong((Object)this.getObject(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return CommonUtils.toFloat((Object)this.getObject(columnIndex));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return CommonUtils.toDouble((Object)this.getObject(columnIndex));
    }

    @Override
    public java.sql.Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Object object;
        block5: {
            object = this.getObject(columnIndex);
            try {
                if (object != null) break block5;
                return null;
            }
            catch (Exception e) {
                throw new SQLException("Error converting from object '" + String.valueOf(object) + "' to date", e);
            }
        }
        if (object instanceof java.sql.Date) {
            return (java.sql.Date)object;
        }
        if (object instanceof Date) {
            return new java.sql.Date(((Date)object).getTime());
        }
        return java.sql.Date.valueOf(object.toString());
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Date timeValue;
        Object object;
        block9: {
            object = this.getObject(columnIndex);
            try {
                if (object != null) break block9;
                return null;
            }
            catch (Exception e) {
                throw new SQLException("Error converting from object '" + String.valueOf(object) + "' to time", e);
            }
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof Date) {
            return new Time(((Date)object).getTime());
        }
        try {
            timeValue = TIME_FORMAT_LONG.parse(object.toString());
        }
        catch (ParseException parseException) {
            try {
                timeValue = TIME_FORMAT_SHORT.parse(object.toString());
            }
            catch (ParseException parseException2) {
                timeValue = Time.valueOf(object.toString());
            }
        }
        return new Time(timeValue.getTime());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Date timeValue;
        Object object;
        block9: {
            object = this.getObject(columnIndex);
            try {
                if (object != null) break block9;
                return null;
            }
            catch (Exception e) {
                throw new SQLException("Error converting from object '" + String.valueOf(object) + "' to timestamp", e);
            }
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof Date) {
            return new Timestamp(((Date)object).getTime());
        }
        try {
            timeValue = TIMESTAMP_FORMAT_LONG.parse(object.toString());
        }
        catch (ParseException parseException) {
            try {
                timeValue = TIMESTAMP_FORMAT_SHORT.parse(object.toString());
            }
            catch (ParseException parseException2) {
                timeValue = Timestamp.valueOf(object.toString());
            }
        }
        return new Timestamp(timeValue.getTime());
    }

    @Override
    public boolean next() throws SQLException {
        ++this.index;
        return this.index < this.rows.length;
    }

    @Override
    public void close() throws SQLException {
        this.rows = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rows == null;
    }
}

