/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.base;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import org.jkiss.code.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public abstract class AbstractJdbcDriver
implements Driver {
    private static final Logger rootLogger = Logger.getLogger(AbstractJdbcDriver.class.getName());
    private final String driverUrlPrefix;
    private final int defaultVersionMajor;
    private final int defaultVersionMinor;

    public AbstractJdbcDriver(String driverUrlPrefix, int defaultVersionMajor, int defaultVersionMinor) {
        this.driverUrlPrefix = driverUrlPrefix;
        this.defaultVersionMajor = defaultVersionMajor;
        this.defaultVersionMinor = defaultVersionMinor;
    }

    public String getDriverUrlPrefix() {
        return this.driverUrlPrefix;
    }

    @Override
    public boolean acceptsURL(String url) {
        return url != null && url.toLowerCase().startsWith(this.driverUrlPrefix);
    }

    @Override
    public final Connection connect(String url, Properties info) throws SQLException {
        this.validateConnection(url, info);
        return this.connectImpl(url, info);
    }

    protected abstract Connection connectImpl(String var1, Properties var2) throws SQLException;

    protected void validateConnection(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            throw new SQLException("Invalid URL: " + url + ", expected prefix '" + this.getDriverUrlPrefix() + "'");
        }
    }

    @Override
    public Logger getParentLogger() {
        return rootLogger;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public int getMajorVersion() {
        try {
            return this.getOwnBundle().getVersion().getMajor();
        }
        catch (Throwable throwable) {
            return this.defaultVersionMajor;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return this.getOwnBundle().getVersion().getMinor();
        }
        catch (Throwable throwable) {
            return this.defaultVersionMinor;
        }
    }

    public int getMicroVersion() {
        try {
            return this.getOwnBundle().getVersion().getMicro();
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    @NotNull
    private Bundle getOwnBundle() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader instanceof BundleReference) {
            return ((BundleReference)classLoader).getBundle();
        }
        throw new IllegalStateException("Not in OSGI context");
    }
}

