/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;

class SQLRoundFunction
extends Expression {
    Expression expression;

    public SQLRoundFunction(Expression expression) {
        this.expression = expression;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Object retval = this.expression.eval(env);
        if (retval != null) {
            if (!(retval instanceof Number)) {
                try {
                    retval = new Double(retval.toString());
                }
                catch (NumberFormatException e) {
                    retval = null;
                }
            }
            if (retval != null) {
                if (retval instanceof Short) {
                    retval = new Integer(((Short)retval).intValue());
                } else if (!(retval instanceof Integer) && !(retval instanceof Long)) {
                    double d = ((Number)retval).doubleValue();
                    retval = d < -2.147483648E9 || d > 2.147483647E9 ? (Number)new Double(Math.round(d)) : (Number)new Integer((int)Math.round(d));
                }
            }
        }
        return retval;
    }

    public String toString() {
        return "ROUND(" + this.expression + ")";
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.expression.usedColumns(availableColumns));
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.expression.aggregateFunctions());
        return result;
    }
}

