/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.AsteriskExpression;
import org.relique.jdbc.csv.Expression;

class SQLCountFunction
extends AggregateFunction {
    HashSet<Object> distinctValues;
    Expression expression;
    int counter = 0;

    public SQLCountFunction(boolean isDistinct, Expression expression) {
        if (isDistinct) {
            this.distinctValues = new HashSet();
        }
        this.expression = expression;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        Integer retval;
        Object o = env.get("@GROUPROWS");
        if (o != null) {
            List groupRows = (List)o;
            if (this.distinctValues != null) {
                HashSet<Object> unique = new HashSet<Object>();
                for (int i = 0; i < groupRows.size(); ++i) {
                    o = this.expression.eval((Map)groupRows.get(i));
                    if (o == null) continue;
                    unique.add(o);
                }
                retval = unique.size();
            } else {
                int groupCounter = 0;
                if (this.expression instanceof AsteriskExpression) {
                    groupCounter = groupRows.size();
                } else {
                    for (int i = 0; i < groupRows.size(); ++i) {
                        o = this.expression.eval((Map)groupRows.get(i));
                        if (o == null) continue;
                        ++groupCounter;
                    }
                }
                retval = groupCounter;
            }
        } else {
            retval = this.distinctValues != null ? Integer.valueOf(this.distinctValues.size()) : Integer.valueOf(this.counter);
        }
        return retval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("COUNT(");
        if (this.distinctValues != null) {
            sb.append("DISTINCT ");
        }
        sb.append(this.expression);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        return new LinkedList<String>();
    }

    @Override
    public List<String> aggregateColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        if (!(this.expression instanceof AsteriskExpression)) {
            result.addAll(this.expression.usedColumns(availableColumns));
        }
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.add(this);
        return result;
    }

    @Override
    public void resetAggregateFunctions() {
        if (this.distinctValues != null) {
            this.distinctValues.clear();
        }
        this.counter = 0;
    }

    @Override
    public void processRow(Map<String, Object> env) throws SQLException {
        if (this.expression instanceof AsteriskExpression) {
            ++this.counter;
        } else {
            Object o = this.expression.eval(env);
            if (o != null) {
                ++this.counter;
                if (this.distinctValues != null) {
                    this.distinctValues.add(o);
                }
            }
        }
    }
}

