/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import org.relique.io.DataReader;
import org.relique.jdbc.csv.CsvRawReader;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.MinimumMemoryMap;
import org.relique.jdbc.csv.StringConverter;

public class CsvReader
extends DataReader {
    private CsvRawReader rawReader;
    private int transposedLines;
    private int transposedFieldsToSkip;
    private String[] columnNames;
    private String[] tableAndColumnNames;
    private String[] aliasedColumnNames;
    private String[] columnTypes;
    private String[] upperColumnNames;
    private Vector<String[]> firstTable;
    private int joiningValueNo;
    private int valuesToJoin;
    private String[] joiningValues;
    private StringConverter converter;
    private String[] fieldValues;
    private int lineNumber;

    public CsvReader(CsvRawReader rawReader, int transposedLines, int transposedFieldsToSkip, String headerline) throws SQLException {
        this.rawReader = rawReader;
        this.transposedLines = transposedLines;
        this.transposedFieldsToSkip = transposedFieldsToSkip;
        this.columnNames = rawReader.parseLine(headerline, true);
        this.firstTable = null;
        this.columnTypes = null;
        if (!this.isPlainReader()) {
            this.firstTable = new Vector();
            this.joiningValueNo = 0;
            this.joiningValues = null;
            try {
                String[] values = null;
                for (int i = 0; i < transposedLines; ++i) {
                    String line = rawReader.getNextDataLine();
                    values = rawReader.parseLine(line, false);
                    this.firstTable.add(values);
                }
                this.valuesToJoin = values.length;
                this.fieldValues = new String[this.columnNames.length];
            }
            catch (IOException e) {
                throw new SQLException(e.toString());
            }
        }
    }

    public void setConverter(StringConverter converter) {
        this.converter = converter;
    }

    private int getTransposedFieldsToSkip() {
        return this.transposedFieldsToSkip;
    }

    private boolean isPlainReader() {
        return this.transposedLines == 0 && this.transposedFieldsToSkip == 0;
    }

    @Override
    public boolean next() throws SQLException {
        int i;
        if (this.isPlainReader()) {
            boolean result = this.rawReader.next();
            this.lineNumber = this.rawReader.getLineNumber();
            this.fieldValues = this.rawReader.getFieldValues();
            return result;
        }
        if (this.joiningValues == null || this.joiningValueNo + this.getTransposedFieldsToSkip() == this.valuesToJoin) {
            String line;
            try {
                line = this.rawReader.getNextDataLine();
                if (line != null) {
                    this.lineNumber = this.rawReader.getLineNumber();
                }
            }
            catch (IOException e) {
                throw new SQLException(e.toString());
            }
            if (line == null) {
                return false;
            }
            this.joiningValues = this.rawReader.parseLine(line, false);
            this.joiningValueNo = 0;
        }
        for (i = 0; i < this.transposedLines; ++i) {
            this.fieldValues[i] = this.firstTable.get(i)[this.joiningValueNo + this.getTransposedFieldsToSkip()];
        }
        for (i = this.transposedLines; i < this.columnNames.length - 1; ++i) {
            this.fieldValues[i] = this.joiningValues[i - this.transposedLines];
        }
        this.fieldValues[this.columnNames.length - 1] = this.joiningValues[this.columnNames.length - this.transposedLines - 1 + this.joiningValueNo];
        ++this.joiningValueNo;
        if (this.columnTypes == null) {
            this.getColumnTypes();
        }
        return true;
    }

    @Override
    public String[] getColumnNames() {
        if (this.isPlainReader()) {
            return this.rawReader.getColumnNames();
        }
        return this.columnNames;
    }

    private String[] getUpperColumnNames() {
        if (this.upperColumnNames == null) {
            String[] columnNames = this.getColumnNames();
            this.upperColumnNames = new String[columnNames.length];
            for (int i = 0; i < this.upperColumnNames.length; ++i) {
                this.upperColumnNames[i] = columnNames[i].toUpperCase();
            }
        }
        return this.upperColumnNames;
    }

    private String[] getTableAndColumnNames() {
        if (this.tableAndColumnNames == null) {
            String upperTableName = this.rawReader.getTableName().toUpperCase();
            String[] upperColumnNames = this.getUpperColumnNames();
            this.tableAndColumnNames = new String[upperColumnNames.length];
            for (int i = 0; i < upperColumnNames.length; ++i) {
                this.tableAndColumnNames[i] = upperTableName + "." + upperColumnNames[i];
            }
        }
        return this.tableAndColumnNames;
    }

    private String[] getAliasedColumnNames() {
        String tableAlias;
        if (this.aliasedColumnNames == null && (tableAlias = this.rawReader.getTableAlias()) != null) {
            String[] upperColumnNames = this.getUpperColumnNames();
            this.aliasedColumnNames = new String[upperColumnNames.length];
            for (int i = 0; i < upperColumnNames.length; ++i) {
                this.aliasedColumnNames[i] = tableAlias + "." + upperColumnNames[i];
            }
        }
        return this.aliasedColumnNames;
    }

    private Object getField(int i) throws SQLException {
        if (this.isPlainReader()) {
            return this.rawReader.getField(i);
        }
        return null;
    }

    @Override
    public void close() {
        this.rawReader.close();
    }

    @Override
    public Map<String, Object> getEnvironment() throws SQLException {
        if (this.fieldValues.length != this.getColumnNames().length) {
            throw new SQLException(CsvResources.getString("wrongColumnCount") + ": " + this.lineNumber + " " + CsvResources.getString("columnsRead") + ": " + this.fieldValues.length + " " + CsvResources.getString("columnsExpected") + ": " + this.getColumnNames().length);
        }
        if (this.columnTypes == null) {
            this.getColumnTypes();
        }
        String[] columnNames = this.getUpperColumnNames();
        String[] tableAndColumnNames = this.getTableAndColumnNames();
        String[] columnAliases = this.getAliasedColumnNames();
        int initialSize = columnNames.length * 2;
        if (columnAliases != null) {
            initialSize += columnNames.length;
        }
        if (initialSize == 0) {
            initialSize = 1;
        }
        MinimumMemoryMap<String, Object> result = new MinimumMemoryMap<String, Object>(initialSize);
        result.put("@STRINGCONVERTER", this.converter);
        for (int i = 0; i < columnNames.length; ++i) {
            String key = columnNames[i];
            Object value = this.converter.convert(this.columnTypes[i], this.fieldValues[i]);
            result.put(key, value);
            result.put(tableAndColumnNames[i], value);
            if (columnAliases == null) continue;
            result.put(columnAliases[i], value);
        }
        return result;
    }

    public void setColumnTypes(String line) throws SQLException {
        int i;
        String[] typeNamesLoc = line.split(",");
        if (typeNamesLoc.length == 0) {
            throw new SQLException(CsvResources.getString("invalidColumnType") + ": " + line);
        }
        this.columnTypes = new String[this.getColumnNames().length];
        for (i = 0; i < Math.min(typeNamesLoc.length, this.columnTypes.length); ++i) {
            String typeName = typeNamesLoc[i].trim();
            if (this.converter.forSQLName(typeName) == null) {
                throw new SQLException(CsvResources.getString("invalidColumnType") + ": " + typeName);
            }
            this.columnTypes[i] = typeName;
        }
        for (i = typeNamesLoc.length; i < this.columnTypes.length; ++i) {
            this.columnTypes[i] = typeNamesLoc[typeNamesLoc.length - 1].trim();
        }
    }

    @Override
    public String[] getColumnTypes() throws SQLException {
        if (this.columnTypes == null) {
            this.inferColumnTypes();
        }
        return this.columnTypes;
    }

    private void inferColumnTypes() throws SQLException {
        if (this.fieldValues == null) {
            throw new SQLException(CsvResources.getString("cannotInferColumns"));
        }
        this.columnTypes = new String[this.fieldValues.length];
        for (int i = 0; i < this.fieldValues.length; ++i) {
            try {
                String typeName = "String";
                String value = this.getField(i).toString();
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                    typeName = "Boolean";
                } else if (value.equals("" + this.converter.parseInt(value))) {
                    typeName = "Int";
                } else if (value.equals("" + this.converter.parseLong(value))) {
                    typeName = "Long";
                } else if (value.equals("" + this.converter.parseDouble(value))) {
                    typeName = "Double";
                } else if (value.equals("" + this.converter.parseBytes(value))) {
                    typeName = "Bytes";
                } else if (value.equals("" + this.converter.parseBigDecimal(value))) {
                    typeName = "BigDecimal";
                } else if (this.converter.parseTimestamp(value) != null) {
                    typeName = "Timestamp";
                } else if (this.converter.parseDate(value) != null) {
                    typeName = "Date";
                } else if (this.converter.parseTime(value) != null) {
                    typeName = "Time";
                } else if (value.equals("" + this.converter.parseAsciiStream(value))) {
                    typeName = "AsciiStream";
                }
                this.columnTypes[i] = typeName;
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public int[] getColumnSizes() {
        return this.rawReader.getColumnSizes();
    }

    @Override
    public String getTableAlias() {
        return this.rawReader.getTableAlias();
    }
}

