/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.ColumnName;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.StringConverter;

class BinaryOperation
extends Expression {
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    String operation;
    char op;
    Expression left;
    Expression right;

    public BinaryOperation(String operation, Expression left, Expression right) {
        this.operation = operation;
        this.op = operation.charAt(0);
        this.left = left;
        this.right = right;
    }

    @Override
    public Object eval(Map<String, Object> env) throws SQLException {
        java.util.Date leftD;
        Object leftEval = this.left.eval(env);
        Object rightEval = this.right.eval(env);
        if (leftEval == null || rightEval == null) {
            return null;
        }
        try {
            BigInteger bir;
            BigInteger bil;
            boolean isLongExpression = false;
            if (leftEval instanceof Short) {
                Integer leftInt = ((Short)leftEval).intValue();
                bil = new BigInteger(leftInt.toString());
            } else if (leftEval instanceof Long) {
                bil = new BigInteger(leftEval.toString());
                isLongExpression = true;
            } else {
                Integer leftInt = (Integer)leftEval;
                bil = new BigInteger(leftInt.toString());
            }
            if (rightEval instanceof Short) {
                Integer rightInt = ((Short)rightEval).intValue();
                bir = new BigInteger(rightInt.toString());
            } else if (rightEval instanceof Long) {
                bir = new BigInteger(rightEval.toString());
                isLongExpression = true;
            } else {
                Integer rightInt = (Integer)rightEval;
                bir = new BigInteger(rightInt.toString());
            }
            if (this.op == '+') {
                bil = bil.add(bir);
            } else if (this.op == '-') {
                bil = bil.subtract(bir);
            } else if (this.op == '*') {
                bil = bil.multiply(bir);
            } else if (this.op == '/') {
                bil = bil.divide(bir);
            } else if (this.op == '%') {
                bil = bil.remainder(bir);
            }
            if (isLongExpression) {
                return new Long(bil.toString());
            }
            return new Integer(bil.toString());
        }
        catch (ClassCastException leftInt) {
        }
        catch (ArithmeticException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            Number leftN = (Number)leftEval;
            BigDecimal bdl = new BigDecimal(leftN.toString());
            Number rightN = (Number)rightEval;
            BigDecimal bdr = new BigDecimal(rightN.toString());
            if (this.op == '+') {
                return new Double(bdl.add(bdr).toString());
            }
            if (this.op == '-') {
                return new Double(bdl.subtract(bdr).toString());
            }
            if (this.op == '*') {
                return new Double(bdl.multiply(bdr).toString());
            }
            MathContext mc = new MathContext("precision=14 roundingMode=HALF_UP");
            if (this.op == '/') {
                return new Double(bdl.divide(bdr, mc.getPrecision(), mc.getRoundingMode()).toString());
            }
            if (this.op == '%') {
                return new Double(bdl.remainder(bdr, mc).toString());
            }
        }
        catch (ClassCastException leftN) {
        }
        catch (ArithmeticException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            StringConverter sc;
            ColumnName stringConverter;
            if (this.op == '+' && leftEval instanceof Date) {
                leftD = (Date)leftEval;
                if (rightEval instanceof Time) {
                    Time rightT = (Time)rightEval;
                    stringConverter = new ColumnName("@STRINGCONVERTER");
                    sc = (StringConverter)((Expression)stringConverter).eval(env);
                    return sc.parseTimestamp(((Date)leftD).toString() + " " + rightT.toString());
                }
                Long rightLong = rightEval instanceof Short ? Long.valueOf(((Short)rightEval).longValue()) : (rightEval instanceof Long ? (Long)rightEval : Long.valueOf(((Integer)rightEval).intValue()));
                return this.incrementDate((Date)leftD, rightLong);
            }
            if (this.op == '+' && rightEval instanceof Date) {
                Date rightD = (Date)rightEval;
                if (leftEval instanceof Time) {
                    Time leftT = (Time)leftEval;
                    stringConverter = new ColumnName("@STRINGCONVERTER");
                    sc = (StringConverter)((Expression)stringConverter).eval(env);
                    return sc.parseTimestamp(rightD.toString() + " " + leftT.toString());
                }
                Long leftLong = leftEval instanceof Short ? Long.valueOf(((Short)leftEval).intValue()) : (leftEval instanceof Long ? (Long)rightEval : Long.valueOf(((Integer)leftEval).intValue()));
                return this.incrementDate(rightD, leftLong);
            }
            if (this.op == '-' && leftEval instanceof Date && rightEval instanceof Long) {
                return this.incrementDate((Date)leftEval, -((Long)rightEval).longValue());
            }
            if (this.op == '-' && leftEval instanceof Date && rightEval instanceof Integer) {
                return this.incrementDate((Date)leftEval, -((Integer)rightEval).intValue());
            }
            if (this.op == '-' && leftEval instanceof Date && rightEval instanceof Short) {
                return this.incrementDate((Date)leftEval, -((Short)rightEval).intValue());
            }
            if (this.op == '-' && (leftEval instanceof Date || rightEval instanceof Date)) {
                StringConverter sc2;
                ColumnName stringConverter2;
                if (!(leftEval instanceof Date)) {
                    stringConverter2 = new ColumnName("@STRINGCONVERTER");
                    sc2 = (StringConverter)((Expression)stringConverter2).eval(env);
                    leftEval = sc2.parseDate(leftEval.toString());
                }
                if (!(rightEval instanceof Date)) {
                    stringConverter2 = new ColumnName("@STRINGCONVERTER");
                    sc2 = (StringConverter)((Expression)stringConverter2).eval(env);
                    rightEval = sc2.parseDate(rightEval.toString());
                }
                if (leftEval != null && rightEval != null) {
                    long nMillis = ((Date)leftEval).getTime() - ((Date)rightEval).getTime();
                    long nDays = (nMillis + 43200000L) / 86400000L;
                    return new Integer((int)nDays);
                }
            }
        }
        catch (ClassCastException nMillis) {
            // empty catch block
        }
        try {
            if (this.op == '+' || this.op == '-') {
                leftD = (Timestamp)leftEval;
                long time = ((Timestamp)leftD).getTime();
                Number rightN = (Number)rightEval;
                BigDecimal bdr = new BigDecimal(rightN.toString());
                if (this.op == '+') {
                    return new Timestamp(time + bdr.longValue());
                }
                if (this.op == '-') {
                    return new Timestamp(time - bdr.longValue());
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (this.op == '+' || this.op == '|') {
            return "" + leftEval + rightEval;
        }
        return null;
    }

    private Date incrementDate(Date date, long nDays) {
        long newTime = date.getTime() + nDays * 86400000L + 43200000L;
        Date newDate = new Date(newTime);
        newDate = Date.valueOf(newDate.toString());
        return newDate;
    }

    public String toString() {
        return "" + this.operation + " " + this.left + " " + this.right;
    }

    @Override
    public List<String> usedColumns(Set<String> availableColumns) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(this.left.usedColumns(availableColumns));
        result.addAll(this.right.usedColumns(availableColumns));
        return result;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> result = new LinkedList<AggregateFunction>();
        result.addAll(this.left.aggregateFunctions());
        result.addAll(this.right.aggregateFunctions());
        return result;
    }

    @Override
    public boolean isValid() {
        if (this.left instanceof LogicalExpression || this.right instanceof LogicalExpression) {
            return false;
        }
        return this.left.isValid() && this.right.isValid();
    }
}

