/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.core.util.InetAddresses;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class ConnectionString {
    public static final String DEFAULT_SCHEME = "couchbase://";
    private static final Pattern connectionStringPattern = Pattern.compile("((?<scheme>.*?)://)?((?<user>.*?)@)?(?<hosts>.*?)(\\?(?<params>.*?))?");
    private final Scheme scheme;
    private final List<UnresolvedSocket> hosts;
    private final Map<String, String> params;
    @Nullable
    private final String username;

    private ConnectionString(Scheme scheme, @Nullable String username, List<UnresolvedSocket> hosts, Map<String, String> params) {
        this.scheme = Objects.requireNonNull(scheme);
        this.username = username;
        this.hosts = CbCollections.listCopyOf(hosts);
        this.params = Collections.unmodifiableMap(new LinkedHashMap<String, String>(params));
    }

    protected ConnectionString(String connectionString) {
        Matcher m = connectionStringPattern.matcher(connectionString);
        if (!m.matches()) {
            throw InvalidArgumentException.fromMessage("Malformed connection string: " + connectionString);
        }
        try {
            this.scheme = Optional.ofNullable(m.group("scheme")).map(x$0 -> Scheme.parse(x$0)).orElse(Scheme.COUCHBASE);
            this.username = m.group("user");
            this.hosts = Collections.unmodifiableList(ConnectionString.parseHosts(m.group("hosts")));
            this.params = Collections.unmodifiableMap(ConnectionString.parseParams(m.group("params")));
        }
        catch (Exception e) {
            throw InvalidArgumentException.fromMessage("Failed to parse connection string \"" + connectionString + "\" ; " + e.getMessage(), e);
        }
    }

    public static ConnectionString create(String connectionString) {
        return new ConnectionString(connectionString);
    }

    public static ConnectionString fromHostnames(List<String> hostnames) {
        return ConnectionString.create(String.join((CharSequence)",", hostnames));
    }

    @Stability.Internal
    public ConnectionString withScheme(Scheme scheme) {
        return new ConnectionString(scheme, this.username(), this.hosts(), this.params());
    }

    @Stability.Internal
    public ConnectionString withParams(Map<String, String> params) {
        return new ConnectionString(this.scheme(), this.username(), this.hosts(), params);
    }

    private static List<UnresolvedSocket> parseHosts(String hosts) {
        return Arrays.stream(hosts.split(",")).map(String::trim).filter(it -> !it.isEmpty()).map(UnresolvedSocket::parse).collect(Collectors.toList());
    }

    private static Map<String, String> parseParams(@Nullable String paramsString) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (!CbStrings.isNullOrEmpty(paramsString)) {
            for (String entry : paramsString.split("&")) {
                String[] nameAndValue = entry.split("=", 2);
                String name = nameAndValue[0];
                String value = nameAndValue.length == 1 ? "" : nameAndValue[1];
                result.put(name, value);
            }
        }
        return result;
    }

    public Scheme scheme() {
        return this.scheme;
    }

    @Nullable
    public String username() {
        return this.username;
    }

    public List<UnresolvedSocket> hosts() {
        return this.hosts;
    }

    public Map<String, String> params() {
        return this.params;
    }

    public boolean isValidDnsSrv() {
        return this.dnsSrvCandidate().isPresent();
    }

    public Optional<String> dnsSrvCandidate() {
        boolean maybeDnsSrv = this.hosts.size() == 1 && this.hosts.get(0).port() == 0 && !InetAddresses.isInetAddress(this.hosts.get(0).hostname());
        return maybeDnsSrv ? Optional.of(this.hosts.get(0).hostname()) : Optional.empty();
    }

    public String toString() {
        return "ConnectionString{scheme=" + (Object)((Object)this.scheme) + ", user=" + this.username + ", hosts=" + this.hosts + ", params=" + this.params + '}';
    }

    public String original() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.scheme.name().toLowerCase(Locale.ROOT)).append("://");
        if (this.username != null) {
            sb.append(this.username).append("@");
        }
        sb.append(String.join((CharSequence)",", CbCollections.transform(this.hosts, UnresolvedSocket::format)));
        if (!this.params.isEmpty()) {
            sb.append("?");
            sb.append(String.join((CharSequence)"&", CbCollections.transform(this.params.entrySet(), it -> (String)it.getKey() + "=" + (String)it.getValue())));
        }
        return sb.toString();
    }

    @Stability.Internal
    public static enum PortType {
        MANAGER,
        KV;


        static PortType fromString(String input) {
            if (input.equalsIgnoreCase("http") || input.equalsIgnoreCase("manager")) {
                return MANAGER;
            }
            if (input.equalsIgnoreCase("mcd") || input.equalsIgnoreCase("kv")) {
                return KV;
            }
            throw InvalidArgumentException.fromMessage("Unsupported port type \"" + input + "\"");
        }
    }

    public static class UnresolvedSocket {
        private final HostAndPort hostAndPort;
        private final Optional<PortType> portType;

        UnresolvedSocket(HostAndPort hostAndPort, @Nullable PortType portType) {
            this.hostAndPort = Objects.requireNonNull(hostAndPort);
            this.portType = Optional.ofNullable(portType);
        }

        @Deprecated
        public String hostname() {
            return this.host();
        }

        public String host() {
            return this.hostAndPort.host();
        }

        public int port() {
            return this.hostAndPort.port();
        }

        public Optional<PortType> portType() {
            return this.portType;
        }

        public String format() {
            StringBuilder sb = new StringBuilder(this.hostAndPort.format());
            this.portType.ifPresent(it -> sb.append("=").append(it.name().toLowerCase(Locale.ROOT)));
            return sb.toString();
        }

        static UnresolvedSocket parse(String address) {
            PortType portType;
            String[] parts = address.split("=", 2);
            HostAndPort hostAndPort = HostAndPort.parse(parts[0]);
            PortType portType2 = portType = parts.length == 1 ? null : PortType.fromString(parts[1]);
            if (hostAndPort.port() == 0 && portType != null) {
                throw new IllegalArgumentException("Malformed address; must specify a port when specifying a port type: " + address);
            }
            return new UnresolvedSocket(hostAndPort, portType);
        }

        public String toString() {
            return "UnresolvedSocket{hostname='" + this.host() + '\'' + ", port=" + this.port() + ", portType=" + this.portType + '}';
        }
    }

    public static enum Scheme {
        COUCHBASE,
        COUCHBASES;


        private static Scheme parse(String s) {
            try {
                return Scheme.valueOf(s.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                List<String> lowercaseNames = CbCollections.transform(Scheme.values(), it -> it.name().toLowerCase(Locale.ROOT));
                throw InvalidArgumentException.fromMessage("Expected scheme to be one of " + lowercaseNames + " but got: " + s);
            }
        }
    }
}

