/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.support;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.transaction.components.DocumentMetadata;
import com.couchbase.client.core.transaction.support.StagedMutationType;
import com.couchbase.client.core.transaction.util.DebugUtil;
import java.util.Optional;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class StagedMutation {
    public final String operationId;
    public final String id;
    public final CollectionIdentifier collection;
    public final long cas;
    public final Optional<DocumentMetadata> documentMetadata;
    public final Optional<String> crc32;
    @Nullable
    public final byte[] content;
    public final StagedMutationType type;

    public StagedMutation(String operationId, String id, CollectionIdentifier collection, long cas, Optional<DocumentMetadata> documentMetadata, Optional<String> crc32, byte[] content, StagedMutationType type) {
        this.operationId = operationId;
        this.id = id;
        this.collection = collection;
        this.cas = cas;
        this.documentMetadata = documentMetadata;
        this.crc32 = crc32;
        this.content = content;
        this.type = type;
    }

    public String toString() {
        return this.type.toString() + " " + DebugUtil.docId(this.collection, this.id);
    }

    public boolean supportsReplaceBodyWithXattr() {
        return this.content == null;
    }
}

