/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.support;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class SpanWrapperUtil {
    private SpanWrapperUtil() {
    }

    public static SpanWrapper createOp(@Nullable CoreTransactionAttemptContext ctx, RequestTracer tracer, @Nullable CollectionIdentifier collection, @Nullable String id, String op, @Nullable SpanWrapper attemptSpan) {
        SpanWrapper out = SpanWrapper.create(tracer, op, attemptSpan);
        if (!out.isInternal()) {
            out.attribute("db.operation", op);
            return SpanWrapperUtil.setAttributes(out, ctx, collection, id);
        }
        return out;
    }

    public static SpanWrapper setAttributes(SpanWrapper out, @Nullable CoreTransactionAttemptContext ctx, @Nullable CollectionIdentifier collection, @Nullable String id) {
        if (!out.isInternal()) {
            out.attribute("db.system", "couchbase").attribute("db.couchbase.service", "transactions");
            if (ctx != null) {
                out.attribute("db.couchbase.transaction.id", ctx.transactionId()).attribute("db.couchbase.transaction.attempt_id", ctx.attemptId());
            }
            if (collection != null) {
                out.attribute("db.name", collection.bucket()).attribute("db.couchbase.scope", collection.scope().orElse("_default")).attribute("db.couchbase.collection", collection.collection().orElse("_default"));
            }
            if (id != null) {
                out.attribute("db.couchbase.document_id", id);
            }
        }
        return out;
    }
}

