/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.support;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

@Stability.Internal
public class OptionsUtil {
    private OptionsUtil() {
    }

    public static Duration kvTimeoutNonMutating(Core core) {
        return core.context().environment().timeoutConfig().kvTimeout();
    }

    public static Duration kvTimeoutMutating(Core core) {
        return core.context().environment().timeoutConfig().kvDurableTimeout();
    }

    public static DurabilityLevel convert(DurabilityLevel dl) {
        switch (dl) {
            case MAJORITY: {
                return DurabilityLevel.MAJORITY;
            }
            case PERSIST_TO_MAJORITY: {
                return DurabilityLevel.PERSIST_TO_MAJORITY;
            }
            case MAJORITY_AND_PERSIST_TO_ACTIVE: {
                return DurabilityLevel.MAJORITY_AND_PERSIST_TO_ACTIVE;
            }
        }
        return DurabilityLevel.NONE;
    }

    public static Map<String, Object> createClientContext(String op) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("txn.op", op);
        return map;
    }
}

