/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.forwards;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.error.transaction.ForwardCompatibilityFailureException;
import com.couchbase.client.core.error.transaction.internal.ForwardCompatibilityRequiresRetryException;
import com.couchbase.client.core.transaction.forwards.ForwardCompatBehaviour;
import com.couchbase.client.core.transaction.forwards.ForwardCompatBehaviourFull;
import com.couchbase.client.core.transaction.forwards.ForwardCompatibilityForStage;
import com.couchbase.client.core.transaction.forwards.ForwardCompatibilityStage;
import com.couchbase.client.core.transaction.forwards.Supported;
import com.couchbase.client.core.transaction.log.CoreTransactionLogger;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ForwardCompatibility {
    private final Map<String, ForwardCompatibilityForStage> compatibilityMap = new HashMap<String, ForwardCompatibilityForStage>();
    private final JsonNode raw;
    private static RuntimeException RETRY = new ForwardCompatibilityRequiresRetryException();
    private static RuntimeException NO_RETRY = new ForwardCompatibilityFailureException();

    public ForwardCompatibility(JsonNode json) {
        Objects.requireNonNull(json);
        this.raw = json;
        Iterator<String> name = json.fieldNames();
        while (name.hasNext()) {
            String n = name.next();
            JsonNode a = json.path(n);
            this.compatibilityMap.put(n, new ForwardCompatibilityForStage(a));
        }
    }

    public ForwardCompatBehaviourFull check(ForwardCompatibilityStage fc, Supported supported) {
        if (this.compatibilityMap.containsKey(fc.value())) {
            ForwardCompatibilityForStage f = this.compatibilityMap.get(fc.value());
            return f.behaviour(supported);
        }
        return ForwardCompatBehaviourFull.CONTINUE;
    }

    public static Mono<Void> check(Core core, ForwardCompatibilityStage fc, Optional<ForwardCompatibility> forwardCompatibility, @Nullable CoreTransactionLogger logger, Supported supported) {
        return Mono.defer(() -> {
            if (forwardCompatibility.isPresent()) {
                RuntimeException toThrow;
                ForwardCompatibility map = (ForwardCompatibility)forwardCompatibility.get();
                ForwardCompatBehaviourFull behaviour = map.check(fc, supported);
                if (behaviour.behaviour == ForwardCompatBehaviour.CONTINUE) {
                    return Mono.empty();
                }
                RuntimeException runtimeException = toThrow = behaviour.behaviour == ForwardCompatBehaviour.RETRY_TRANSACTION ? RETRY : NO_RETRY;
                if (logger != null) {
                    logger.warn("", String.format("forward-compatibility rejection at point '%s'/'%s', map is %s, supported is %s", fc.name(), fc.value(), map.raw, supported));
                }
                if (behaviour.retryAfterMillis.isPresent()) {
                    return Mono.delay((Duration)Duration.ofMillis(behaviour.retryAfterMillis.get().intValue()), (Scheduler)core.context().environment().transactionsSchedulers().schedulerBlocking()).then(Mono.error((Throwable)toThrow));
                }
                return Mono.error((Throwable)toThrow);
            }
            return Mono.empty();
        });
    }

    public String toString() {
        return this.raw.toString();
    }
}

