/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.transaction.cleanup.CleanerFactory;
import com.couchbase.client.core.transaction.cleanup.ClientRecordFactory;
import com.couchbase.client.core.transaction.config.CoreTransactionsCleanupConfig;
import com.couchbase.client.core.transaction.support.TransactionAttemptContextFactory;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreTransactionsConfig {
    public static final Duration DEFAULT_TRANSACTION_TIMEOUT = Duration.ofSeconds(15L);
    public static final DurabilityLevel DEFAULT_TRANSACTION_DURABILITY_LEVEL = DurabilityLevel.MAJORITY;
    private final DurabilityLevel durabilityLevel;
    private final Duration timeout;
    private final CoreTransactionsCleanupConfig cleanupConfig;
    private final TransactionAttemptContextFactory attemptContextFactory;
    private final CleanerFactory cleanerFactory;
    private final ClientRecordFactory clientRecordFactory;
    private final int numAtrs;
    private final Optional<CollectionIdentifier> metadataCollection;
    private final Optional<String> scanConsistency;

    public CoreTransactionsConfig(DurabilityLevel durabilityLevel, Duration timeout, CoreTransactionsCleanupConfig cleanupConfig, @Nullable TransactionAttemptContextFactory attemptContextFactory, @Nullable CleanerFactory cleanerFactory, @Nullable ClientRecordFactory clientRecordFactory, int numAtrs, Optional<CollectionIdentifier> metadataCollection, Optional<String> scanConsistency) {
        this.durabilityLevel = Objects.requireNonNull(durabilityLevel);
        this.timeout = Objects.requireNonNull(timeout);
        this.cleanupConfig = Objects.requireNonNull(cleanupConfig);
        this.attemptContextFactory = attemptContextFactory == null ? new TransactionAttemptContextFactory() : attemptContextFactory;
        this.cleanerFactory = cleanerFactory == null ? new CleanerFactory() : cleanerFactory;
        this.clientRecordFactory = clientRecordFactory == null ? new ClientRecordFactory() : clientRecordFactory;
        this.numAtrs = numAtrs;
        this.metadataCollection = Objects.requireNonNull(metadataCollection);
        this.scanConsistency = Objects.requireNonNull(scanConsistency);
        metadataCollection.ifPresent(mc -> cleanupConfig.cleanupSet().add((CollectionIdentifier)mc));
    }

    @Stability.Internal
    public static CoreTransactionsConfig createDefault() {
        return new CoreTransactionsConfig(DEFAULT_TRANSACTION_DURABILITY_LEVEL, DEFAULT_TRANSACTION_TIMEOUT, CoreTransactionsCleanupConfig.createDefault(), new TransactionAttemptContextFactory(), new CleanerFactory(), new ClientRecordFactory(), 1024, Optional.empty(), Optional.empty());
    }

    public static CoreTransactionsConfig createForSingleQueryTransactions(DurabilityLevel durabilityLevel, Duration timeout, TransactionAttemptContextFactory transactionAttemptContextFactory, Optional<CollectionIdentifier> metadataCollection) {
        return new CoreTransactionsConfig(durabilityLevel, timeout, CoreTransactionsCleanupConfig.createForSingleQueryTransactions(), transactionAttemptContextFactory, null, null, 1024, metadataCollection, Optional.empty());
    }

    public CoreTransactionsCleanupConfig cleanupConfig() {
        return this.cleanupConfig;
    }

    public Duration transactionExpirationTime() {
        return this.timeout;
    }

    public DurabilityLevel durabilityLevel() {
        return this.durabilityLevel;
    }

    public TransactionAttemptContextFactory attemptContextFactory() {
        return this.attemptContextFactory;
    }

    public CleanerFactory cleanerFactory() {
        return this.cleanerFactory;
    }

    public ClientRecordFactory clientRecordFactory() {
        return this.clientRecordFactory;
    }

    public int numAtrs() {
        return this.numAtrs;
    }

    public Optional<CollectionIdentifier> metadataCollection() {
        return this.metadataCollection;
    }

    public Optional<String> scanConsistency() {
        return this.scanConsistency;
    }

    @Stability.Volatile
    public Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("durabilityLevel", this.durabilityLevel.name());
        export.put("timeoutMs", this.timeout.toMillis());
        export.put("cleanupConfig", this.cleanupConfig.exportAsMap());
        export.put("numAtrs", this.numAtrs);
        export.put("metadataCollection", this.metadataCollection.map(CollectionIdentifier::toString).orElse("none"));
        export.put("scanConsistency", this.scanConsistency.orElse("none"));
        return export;
    }
}

