/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.components;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.core.msg.kv.SubdocGetRequest;
import com.couchbase.client.core.transaction.components.ActiveTransactionRecordEntry;
import com.couchbase.client.core.transaction.components.ActiveTransactionRecords;
import com.couchbase.client.core.transaction.components.CasMode;
import com.couchbase.client.core.transaction.components.DocRecord;
import com.couchbase.client.core.transaction.components.DurabilityLevelUtil;
import com.couchbase.client.core.transaction.config.CoreMergedTransactionConfig;
import com.couchbase.client.core.transaction.forwards.ForwardCompatibility;
import com.couchbase.client.core.transaction.log.CoreTransactionLogger;
import com.couchbase.client.core.transaction.support.AttemptState;
import com.couchbase.client.core.transaction.support.OptionsUtil;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.core.transaction.util.DebugUtil;
import com.couchbase.client.core.transaction.util.MeteringUnits;
import com.couchbase.client.core.transaction.util.TransactionKVHandler;
import com.couchbase.client.core.util.CbStrings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ActiveTransactionRecord {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private ActiveTransactionRecord() {
    }

    public static Mono<Optional<ActiveTransactionRecordEntry>> findEntryForTransaction(Core core, CollectionIdentifier atrCollection, String atrId, String attemptId, CoreMergedTransactionConfig config, @Nullable SpanWrapper pspan, @Nullable CoreTransactionLogger logger) {
        return ActiveTransactionRecord.findEntryForTransaction(core, atrCollection, atrId, attemptId, config, pspan, logger, null);
    }

    public static Mono<Optional<ActiveTransactionRecordEntry>> findEntryForTransaction(Core core, CollectionIdentifier atrCollection, String atrId, String attemptId, CoreMergedTransactionConfig config, @Nullable SpanWrapper pspan, @Nullable CoreTransactionLogger logger, @Nullable MeteringUnits.MeteringUnitsBuilder units) {
        return TransactionKVHandler.lookupIn(core, atrCollection, atrId, OptionsUtil.kvTimeoutNonMutating(core), false, OptionsUtil.createClientContext("ATR::findEntryForTransaction"), pspan, Arrays.asList(new SubdocGetRequest.Command(SubdocCommandType.GET, "attempts." + attemptId, true, 0), new SubdocGetRequest.Command(SubdocCommandType.GET, "$vbucket.HLC", true, 1))).map(d -> {
            if (units != null) {
                units.add(d.flexibleExtras());
            }
            if (!d.values()[0].status().success()) {
                return Optional.empty();
            }
            try {
                JsonNode atr = MAPPER.readValue(d.values()[0].value(), JsonNode.class);
                JsonNode hlc = MAPPER.readValue(d.values()[1].value(), JsonNode.class);
                ParsedHLC parsedHLC = new ParsedHLC(hlc);
                ActiveTransactionRecordEntry entry = ActiveTransactionRecord.createFrom(atrCollection.bucket(), atrId, atr, attemptId, parsedHLC.nowInNanos());
                return Optional.of(entry);
            }
            catch (Throwable err) {
                if (logger != null) {
                    logger.info("", String.format("Hit error while decoding ATR %s.%s.%s.%s %s %s", atrCollection.bucket(), atrCollection.scope(), atrCollection.collection(), atrId, attemptId, DebugUtil.dbg(err)));
                    logger.warn("Attempt to dump raw JSON of ATR entry:");
                    try {
                        byte[] raw = d.values()[0].value();
                        String asStr = new String(raw, StandardCharsets.UTF_8);
                        logger.info("", "Raw JSON: %s", asStr);
                        byte[] rawHLC = d.values()[1].value();
                        String asStrHLC = new String(rawHLC, StandardCharsets.UTF_8);
                        logger.info("", "Raw JSON HLC: %s", asStrHLC);
                    }
                    catch (Throwable e) {
                        logger.info("", "Error while trying to read raw JSON: %s", DebugUtil.dbg(e));
                    }
                }
                throw new RuntimeException(err);
            }
        });
    }

    public static ActiveTransactionRecordEntry createFrom(String atrBucket, String atrId, JsonNode entry, String attemptId, long cas) {
        Objects.requireNonNull(entry);
        Objects.requireNonNull(attemptId);
        AttemptState state = AttemptState.convert(entry.path("st").textValue());
        Optional<ForwardCompatibility> fc = Optional.ofNullable(entry.path("fc")).map(ForwardCompatibility::new);
        Optional<DurabilityLevel> dl = Optional.ofNullable(entry.path("d").textValue()).map(DurabilityLevelUtil::convertDurabilityLevel);
        return new ActiveTransactionRecordEntry(atrBucket, atrId, attemptId, Optional.ofNullable(entry.path("tid").textValue()), state, ActiveTransactionRecord.parseMutationCASField(entry.path("tst").textValue()), ActiveTransactionRecord.parseMutationCASField(entry.path("tsc").textValue()), ActiveTransactionRecord.parseMutationCASField(entry.path("tsco").textValue()), ActiveTransactionRecord.parseMutationCASField(entry.path("tsrs").textValue()), ActiveTransactionRecord.parseMutationCASField(entry.path("tsrc").textValue()), Optional.ofNullable(entry.get("exp") == null ? null : Integer.valueOf(entry.get("exp").intValue())), ActiveTransactionRecord.processDocumentIdArray(entry.get("ins")), ActiveTransactionRecord.processDocumentIdArray(entry.get("rep")), ActiveTransactionRecord.processDocumentIdArray(entry.get("rem")), cas, fc, dl);
    }

    public static Optional<List<DocRecord>> processDocumentIdArray(@Nullable JsonNode array) {
        if (array == null) {
            return Optional.empty();
        }
        return Optional.of(StreamSupport.stream(array.spliterator(), false).map(DocRecord::createFrom).collect(Collectors.toList()));
    }

    public static long parseMutationCAS(String in) {
        return TimeUnit.NANOSECONDS.toMillis(Long.reverseBytes(Long.parseUnsignedLong(CbStrings.removeStart(in, "0x"), 16)));
    }

    public static Optional<Long> parseMutationCASField(String str) {
        if (str == null) {
            return Optional.empty();
        }
        return Optional.of(ActiveTransactionRecord.parseMutationCAS(str));
    }

    public static Mono<Optional<ActiveTransactionRecords>> getAtr(Core core, CollectionIdentifier atrCollection, String atrId, Duration timeout, @Nullable SpanWrapper pspan) {
        return TransactionKVHandler.lookupIn(core, atrCollection, atrId, timeout, false, OptionsUtil.createClientContext("ATR::getAtr"), pspan, Arrays.asList(new SubdocGetRequest.Command(SubdocCommandType.GET, "attempts", true, 0), new SubdocGetRequest.Command(SubdocCommandType.GET, "$vbucket.HLC", true, 1))).map(d -> {
            try {
                JsonNode attempts = MAPPER.readValue(d.values()[0].value(), JsonNode.class);
                JsonNode hlc = MAPPER.readValue(d.values()[1].value(), JsonNode.class);
                ParsedHLC parsedHLC = new ParsedHLC(hlc);
                return Optional.of(ActiveTransactionRecord.mapToAtr(atrCollection, atrId, attempts, parsedHLC.nowInNanos(), parsedHLC.mode()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).onErrorResume(err -> {
            if (err instanceof DocumentNotFoundException) {
                return Mono.just(Optional.empty());
            }
            return Mono.error((Throwable)err);
        });
    }

    private static ActiveTransactionRecords mapToAtr(CollectionIdentifier atrCollection, String atrId, JsonNode attempts, long cas, CasMode casMode) {
        List<ActiveTransactionRecordEntry> entries = StreamSupport.stream(Spliterators.spliteratorUnknownSize(attempts.fields(), 16), false).map(jo -> ActiveTransactionRecord.createFrom(atrCollection.bucket(), atrId, (JsonNode)jo.getValue(), (String)jo.getKey(), cas)).collect(Collectors.toList());
        return new ActiveTransactionRecords(atrId, atrCollection, cas, entries, casMode);
    }

    @Stability.Internal
    public static class ParsedHLC {
        private final CasMode mode;
        private final long nowInNanos;

        public ParsedHLC(JsonNode hlc) {
            String nowStr = hlc.path("now").textValue();
            String modeStr = hlc.path("mode").textValue();
            if (modeStr != null && modeStr.length() > 0) {
                switch (modeStr.charAt(0)) {
                    case 'l': {
                        this.mode = CasMode.LOGICAL;
                        break;
                    }
                    case 'r': {
                        this.mode = CasMode.REAL;
                        break;
                    }
                    default: {
                        this.mode = CasMode.UNKNOWN;
                        break;
                    }
                }
            } else {
                this.mode = CasMode.UNKNOWN;
            }
            long nowSeconds = Long.parseLong(nowStr);
            this.nowInNanos = TimeUnit.SECONDS.toNanos(nowSeconds);
        }

        public CasMode mode() {
            return this.mode;
        }

        public long nowInNanos() {
            return this.nowInNanos;
        }
    }
}

