/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.endpoint.BackupEndpoint;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.service.EndpointSelectionStrategy;
import com.couchbase.client.core.service.PooledService;
import com.couchbase.client.core.service.ServiceConfig;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.service.strategy.RoundRobinSelectionStrategy;
import java.time.Duration;
import java.util.Optional;

public class BackupService
extends PooledService {
    private final String hostname;
    private final int port;

    public BackupService(CoreContext coreContext, String hostname, int port) {
        super(new BackupServiceConfig(), new ServiceContext(coreContext, hostname, port, ServiceType.BACKUP, Optional.empty()));
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    protected Endpoint createEndpoint() {
        return new BackupEndpoint(this.serviceContext(), this.hostname, this.port);
    }

    @Override
    protected EndpointSelectionStrategy selectionStrategy() {
        return new RoundRobinSelectionStrategy();
    }

    @Override
    public ServiceType type() {
        return ServiceType.BACKUP;
    }

    static class BackupServiceConfig
    implements ServiceConfig {
        BackupServiceConfig() {
        }

        @Override
        public int minEndpoints() {
            return 0;
        }

        @Override
        public int maxEndpoints() {
            return 16;
        }

        @Override
        public Duration idleTime() {
            return Duration.ofSeconds(60L);
        }

        @Override
        public boolean pipelined() {
            return false;
        }
    }
}

