/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.manager;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.BaseResponse;
import com.couchbase.client.core.msg.ResponseStatus;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class BucketConfigStreamingResponse
extends BaseResponse {
    private final Sinks.Many<String> configsSink = Sinks.many().replay().latest();
    private final Flux<String> configs = this.configsSink.asFlux();
    private final String address;

    BucketConfigStreamingResponse(ResponseStatus status, String address) {
        super(status);
        this.address = address;
    }

    @Stability.Internal
    public void pushConfig(String config) {
        this.configsSink.emitNext((Object)config, Reactor.emitFailureHandler());
    }

    @Stability.Internal
    public void completeStream() {
        this.configsSink.emitComplete(Reactor.emitFailureHandler());
    }

    @Stability.Internal
    public void failStream(Throwable e) {
        this.configsSink.emitError(e, Reactor.emitFailureHandler());
    }

    public Flux<String> configs() {
        return this.configs;
    }

    public String address() {
        return this.address;
    }
}

