/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.kv.CoreRangeScanId;
import com.couchbase.client.core.kv.CoreRangeScanItem;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.PredeterminedPartitionRequest;
import com.couchbase.client.core.msg.kv.RangeScanContinueResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import reactor.core.publisher.Sinks;

public class RangeScanContinueRequest
extends PredeterminedPartitionRequest<RangeScanContinueResponse> {
    private final CoreRangeScanId id;
    private final int itemLimit;
    private final int byteLimit;
    private final int timeLimit;
    private final Sinks.Many<CoreRangeScanItem> sink;
    private final boolean keysOnly;

    public RangeScanContinueRequest(CoreRangeScanId id, int itemLimit, int byteLimit, Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, String key, CollectionIdentifier collectionIdentifier, RequestSpan span, Sinks.Many<CoreRangeScanItem> sink, short partition, boolean keysOnly) {
        super(partition, timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        this.id = id;
        this.itemLimit = itemLimit;
        this.byteLimit = byteLimit;
        this.timeLimit = Math.toIntExact(timeout.toMillis());
        this.sink = sink;
        this.keysOnly = keysOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf extras = alloc.buffer(12 + this.id.bytes().length);
        try {
            extras.writeBytes(this.id.bytes());
            extras.writeInt(this.itemLimit);
            extras.writeInt(this.timeLimit);
            extras.writeInt(this.byteLimit);
            ByteBuf byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.RANGE_SCAN_CONTINUE, MemcacheProtocol.noDatatype(), this.partition(), opaque, MemcacheProtocol.noCas(), extras, MemcacheProtocol.noKey(), MemcacheProtocol.noBody());
            return byteBuf;
        }
        finally {
            extras.release();
        }
    }

    @Override
    public RangeScanContinueResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        return new RangeScanContinueResponse(status, this.sink, this.keysOnly);
    }

    public CoreRangeScanId rangeScanId() {
        return this.id;
    }
}

