/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.config.BucketCapabilities;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.error.AuthenticationFailureException;
import com.couchbase.client.core.error.CollectionNotFoundException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.InternalServerFailureException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.MutationTokenOutdatedException;
import com.couchbase.client.core.error.RangeScanCanceledException;
import com.couchbase.client.core.error.RangeScanIdFailureException;
import com.couchbase.client.core.error.RangeScanPartitionFailedException;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.error.context.CancellationErrorContext;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.kv.CoreRangeScanId;
import com.couchbase.client.core.kv.CoreRangeScanItem;
import com.couchbase.client.core.kv.CoreRangeScanSort;
import com.couchbase.client.core.kv.LastCoreRangeScanItem;
import com.couchbase.client.core.kv.RangeScanContext;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.kv.RangeScanContinueRequest;
import com.couchbase.client.core.msg.kv.RangeScanCreateRequest;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Scheduler;
import reactor.util.retry.Retry;

@Stability.Internal
public class RangeScanOrchestrator {
    public static final int RANGE_SCAN_DEFAULT_BATCH_BYTE_LIMIT = 15000;
    public static final int RANGE_SCAN_DEFAULT_BATCH_ITEM_LIMIT = 50;
    private final Core core;
    private final CollectionIdentifier collectionIdentifier;
    private volatile BucketConfig currentBucketConfig;
    private volatile boolean capabilityEnabled = false;

    public RangeScanOrchestrator(Core core, CollectionIdentifier collectionIdentifier) {
        this.core = Validators.notNull(core, "Core");
        this.collectionIdentifier = Validators.notNull(collectionIdentifier, "CollectionIdentifier");
        core.configurationProvider().configs().subscribe(cc -> {
            BucketConfig bucketConfig = cc.bucketConfig(collectionIdentifier.bucket());
            if (bucketConfig != null) {
                this.currentBucketConfig = bucketConfig;
                this.capabilityEnabled = bucketConfig.bucketCapabilities().contains((Object)BucketCapabilities.RANGE_SCAN);
            }
        });
    }

    public Flux<CoreRangeScanItem> rangeScan(byte[] startTerm, boolean startExclusive, byte[] endTerm, boolean endExclusive, Duration timeout, int continueItemLimit, int continueByteLimit, boolean keysOnly, CoreRangeScanSort sort, Optional<RequestSpan> parent, Map<Short, MutationToken> consistencyTokens) {
        return Flux.defer(() -> {
            if (this.currentBucketConfig == null) {
                return Mono.delay((Duration)Duration.ofMillis(100L), (Scheduler)this.core.context().environment().scheduler()).flatMapMany(ign -> this.rangeScan(startTerm, startExclusive, endTerm, endExclusive, timeout, continueItemLimit, continueByteLimit, keysOnly, sort, parent, consistencyTokens));
            }
            if (!(this.currentBucketConfig instanceof CouchbaseBucketConfig)) {
                return Flux.error((Throwable)new IllegalStateException("Only Couchbase buckets are supported with KV Range Scan"));
            }
            return this.streamForPartitions((partition, start) -> {
                CoreContext ctx = this.core.context();
                RequestSpan span = ctx.environment().requestTracer().requestSpan("range_scan_create", parent.orElse(null));
                Optional<MutationToken> mutationToken = Optional.ofNullable((MutationToken)consistencyTokens.get(partition));
                byte[] actualStartTerm = start == null ? startTerm : start;
                return RangeScanCreateRequest.forRangeScan(actualStartTerm, startExclusive, endTerm, endExclusive, keysOnly, timeout, this.core.context(), this.core.context().environment().retryStrategy(), this.collectionIdentifier, span, partition, mutationToken);
            }, sort, timeout, continueItemLimit, continueByteLimit, parent, keysOnly);
        });
    }

    public Flux<CoreRangeScanItem> samplingScan(long limit, Optional<Long> seed, Duration timeout, int continueItemLimit, int continueByteLimit, boolean keysOnly, CoreRangeScanSort sort, Optional<RequestSpan> parent, Map<Short, MutationToken> consistencyTokens) {
        return Flux.defer(() -> {
            if (this.currentBucketConfig == null) {
                return Mono.delay((Duration)Duration.ofMillis(100L), (Scheduler)this.core.context().environment().scheduler()).flatMapMany(ign -> this.samplingScan(limit, seed, timeout, continueItemLimit, continueByteLimit, keysOnly, sort, parent, consistencyTokens));
            }
            if (!(this.currentBucketConfig instanceof CouchbaseBucketConfig)) {
                return Flux.error((Throwable)new IllegalStateException("Only Couchbase buckets are supported with KV Range Scan"));
            }
            return this.streamForPartitions((partition, ignored) -> {
                CoreContext ctx = this.core.context();
                RequestSpan span = ctx.environment().requestTracer().requestSpan("range_scan_create", parent.orElse(null));
                Optional<MutationToken> mutationToken = Optional.ofNullable((MutationToken)consistencyTokens.get(partition));
                return RangeScanCreateRequest.forSamplingScan(limit, seed, keysOnly, timeout, ctx, ctx.environment().retryStrategy(), this.collectionIdentifier, span, partition, mutationToken);
            }, sort, timeout, continueItemLimit, continueByteLimit, parent, keysOnly);
        }).take(limit);
    }

    private Flux<CoreRangeScanItem> streamForPartitions(BiFunction<Short, byte[], RangeScanCreateRequest> createSupplier, CoreRangeScanSort sort, Duration timeout, int itemLimit, int byteLimit, Optional<RequestSpan> parent, boolean keysOnly) {
        if (!this.capabilityEnabled) {
            return Flux.error((Throwable)FeatureNotAvailableException.rangeScan());
        }
        AtomicLong itemsStreamed = new AtomicLong();
        short s = ((CouchbaseBucketConfig)this.currentBucketConfig).numberOfPartitions();
        ArrayList<Flux<CoreRangeScanItem>> partitionStreams = new ArrayList<Flux<CoreRangeScanItem>>(s);
        for (short i = 0; i < s; i = (short)(i + 1)) {
            partitionStreams.add(this.streamForPartition(i, createSupplier, timeout, itemLimit, byteLimit, parent, keysOnly));
        }
        Flux stream = CoreRangeScanSort.ASCENDING == sort ? Flux.mergeComparing(Comparator.comparing(CoreRangeScanItem::key), (Publisher[])((Publisher[])partitionStreams.toArray(new Flux[0]))) : Flux.merge(partitionStreams);
        return stream.doOnNext(item -> itemsStreamed.incrementAndGet()).timeout(timeout, (Publisher)Mono.defer(() -> Mono.error((Throwable)new UnambiguousTimeoutException("RangeScan timed out", new CancellationErrorContext(new RangeScanContext(itemsStreamed.get()))))));
    }

    private Flux<CoreRangeScanItem> streamForPartition(short partition, BiFunction<Short, byte[], RangeScanCreateRequest> createSupplier, Duration timeout, int itemLimit, int byteLimit, Optional<RequestSpan> parent, boolean keysOnly) {
        AtomicReference lastStreamed = new AtomicReference();
        return Flux.defer(() -> {
            RangeScanCreateRequest request = (RangeScanCreateRequest)createSupplier.apply(partition, (byte[])lastStreamed.get());
            this.core.send(request);
            return Reactor.wrap(request, request.response(), true).flatMapMany(res -> {
                if (res.status().success()) {
                    return this.continueScan(timeout, partition, res.rangeScanId(), itemLimit, byteLimit, parent, keysOnly);
                }
                KeyValueErrorContext errorContext = KeyValueErrorContext.completedRequest(request, res);
                switch (res.status()) {
                    case NOT_FOUND: {
                        return Flux.empty();
                    }
                    case INTERNAL_SERVER_ERROR: {
                        return Flux.error((Throwable)new InternalServerFailureException(errorContext));
                    }
                    case VBUUID_NOT_EQUAL: {
                        return Flux.error((Throwable)new MutationTokenOutdatedException(errorContext));
                    }
                }
                return Flux.error((Throwable)new CouchbaseException(res.toString(), errorContext));
            });
        }).doOnNext(item -> lastStreamed.set(item.keyBytes())).retryWhen(Retry.from(companion -> companion.map(rs -> {
            if (rs.failure() instanceof RangeScanPartitionFailedException && ((RangeScanPartitionFailedException)rs.failure()).status() == ResponseStatus.NOT_MY_VBUCKET) {
                return Boolean.valueOf(true);
            }
            return Exceptions.propagate((Throwable)rs.failure());
        })));
    }

    private Flux<CoreRangeScanItem> continueScan(Duration timeout, short partition, CoreRangeScanId id, int itemLimit, int byteLimit, Optional<RequestSpan> parent, boolean keysOnly) {
        AtomicBoolean complete = new AtomicBoolean(false);
        return Flux.defer(() -> {
            CoreContext ctx = this.core.context();
            RequestSpan span = ctx.environment().requestTracer().requestSpan("range_scan_continue", parent.orElse(null));
            RangeScanContinueRequest request = new RangeScanContinueRequest(id, itemLimit, byteLimit, timeout, ctx, ctx.environment().retryStrategy(), null, this.collectionIdentifier, span, (Sinks.Many<CoreRangeScanItem>)Sinks.many().unicast().onBackpressureBuffer(), partition, keysOnly);
            this.core.send(request);
            return Reactor.wrap(request, request.response(), true).flatMapMany(res -> {
                if (res.status() == ResponseStatus.SUCCESS || res.status() == ResponseStatus.COMPLETE) {
                    return res.items();
                }
                KeyValueErrorContext errorContext = KeyValueErrorContext.completedRequest(request, res);
                switch (res.status()) {
                    case NOT_FOUND: {
                        return Flux.error((Throwable)new RangeScanIdFailureException(errorContext));
                    }
                    case INVALID_REQUEST: {
                        return Flux.error((Throwable)new InvalidArgumentException("The request failed the server-side input validation check.", null, errorContext));
                    }
                    case NO_ACCESS: {
                        return Flux.error((Throwable)new AuthenticationFailureException("The user is no longer authorized to perform this operation", errorContext, null));
                    }
                    case CANCELED: {
                        return Flux.error((Throwable)new RangeScanCanceledException(errorContext));
                    }
                    case NOT_MY_VBUCKET: {
                        return Flux.error((Throwable)new RangeScanPartitionFailedException("Received \"Not My VBucket\" for the continue response", res.status()));
                    }
                    case UNKNOWN_COLLECTION: {
                        return Flux.error((Throwable)new CollectionNotFoundException(request.collectionIdentifier().collection().orElse("_default"), errorContext));
                    }
                    case SERVER_BUSY: {
                        return Flux.error((Throwable)new CouchbaseException("The range scan for this partition is already streaming on another connection - this is a SDK bug please report.", errorContext));
                    }
                }
                return Flux.error((Throwable)new CouchbaseException(res.toString(), errorContext));
            });
        }).map(item -> {
            if (item instanceof LastCoreRangeScanItem) {
                complete.set(true);
            }
            return item;
        }).repeat(() -> !complete.get()).filter(item -> !(item instanceof LastCoreRangeScanItem));
    }
}

