/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.json.stream;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.json.Mapper;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class MatchedValue {
    private final String jsonPointer;
    private final byte[] json;

    MatchedValue(String jsonPointer, byte[] json) {
        this.jsonPointer = jsonPointer;
        this.json = Objects.requireNonNull(json);
    }

    public boolean isNull() {
        return this.json[0] == 110;
    }

    public byte[] readBytes() {
        return this.json;
    }

    public JsonNode readTree() {
        try {
            return Objects.requireNonNull(Mapper.decodeIntoTree(this.json));
        }
        catch (Exception shouldNeverHappen) {
            throw new AssertionError("Value at " + this.jsonPointer + " is not JSON.", shouldNeverHappen);
        }
    }

    public String readString() {
        return this.read(String.class);
    }

    public double readDouble() {
        return this.read(Double.class);
    }

    public long readLong() {
        return this.read(Long.class);
    }

    public boolean readBoolean() {
        return this.read(Boolean.class);
    }

    private <T> T read(Class<T> type) {
        try {
            return Objects.requireNonNull(Mapper.decodeInto(this.json, type));
        }
        catch (Exception e) {
            throw new DecodingFailureException("Value at " + this.jsonPointer + " is not a " + type.getSimpleName(), e);
        }
    }

    public String toString() {
        return "JsonValue{jsonPointer='" + this.jsonPointer + '\'' + ", json=" + new String(this.json, StandardCharsets.UTF_8) + '}';
    }
}

