/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error.context;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.view.ViewError;
import java.util.Map;

@Stability.Uncommitted
public class ViewErrorContext
extends ErrorContext {
    private final RequestContext requestContext;
    private final ViewError viewError;
    private final int httpStatus;

    public ViewErrorContext(ResponseStatus responseStatus, RequestContext requestContext, ViewError viewError, int httpStatus) {
        super(responseStatus);
        this.requestContext = requestContext;
        this.viewError = viewError;
        this.httpStatus = httpStatus;
    }

    public RequestContext requestContext() {
        return this.requestContext;
    }

    public int httpStatus() {
        return this.httpStatus;
    }

    public ViewError error() {
        return this.viewError;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        if (this.requestContext != null) {
            this.requestContext.injectExportableParams(input);
        }
        if (this.viewError != null) {
            input.put("viewError", this.viewError.error());
            input.put("viewErrorReason", this.viewError.reason());
        }
        input.put("httpStatus", this.httpStatus);
    }
}

