/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Stability.Internal
public class IndexesNotReadyException
extends RuntimeException {
    private final Map<String, String> indexNameToState;

    public IndexesNotReadyException(Map<String, String> indexNameToState) {
        super("Statuses of offline indexes: " + RedactableArgument.redactMeta(indexNameToState));
        this.indexNameToState = Collections.unmodifiableMap(new HashMap<String, String>(indexNameToState));
    }

    public Map<String, String> indexNameToState() {
        return this.indexNameToState;
    }
}

