/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.env.ConfigurationProfile;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Stability.Volatile
public class WanDevelopmentProfile
implements ConfigurationProfile {
    public static Duration CONNECT_TIMEOUT = Duration.ofSeconds(20L);
    public static Duration KV_TIMEOUT = Duration.ofSeconds(20L);
    public static Duration SERVICE_TIMEOUT = Duration.ofSeconds(120L);

    @Override
    public String name() {
        return "wan-development";
    }

    @Override
    public Map<String, String> properties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String connectTimeout = TimeUnit.MILLISECONDS.toSeconds(CONNECT_TIMEOUT.toMillis()) + "s";
        String kvTimeout = TimeUnit.MILLISECONDS.toSeconds(KV_TIMEOUT.toMillis()) + "s";
        String serviceTimeout = TimeUnit.MILLISECONDS.toSeconds(SERVICE_TIMEOUT.toMillis()) + "s";
        properties.put("timeout.connectTimeout", connectTimeout);
        properties.put("timeout.kvTimeout", kvTimeout);
        properties.put("timeout.kvDurableTimeout", kvTimeout);
        properties.put("timeout.viewTimeout", serviceTimeout);
        properties.put("timeout.queryTimeout", serviceTimeout);
        properties.put("timeout.analyticsTimeout", serviceTimeout);
        properties.put("timeout.searchTimeout", serviceTimeout);
        properties.put("timeout.managementTimeout", serviceTimeout);
        return properties;
    }
}

