/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.endpoint.CircuitBreaker;
import com.couchbase.client.core.endpoint.CircuitBreakerConfig;
import com.couchbase.client.core.error.InvalidArgumentException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class LazyCircuitBreaker
implements CircuitBreaker {
    private final CircuitBreakerConfig config;
    private final long rollingWindow;
    private final long sleepingWindow;
    private final AtomicReference<CircuitBreaker.State> state;
    private volatile long windowStartTimestamp;
    private final AtomicLong totalInWindow;
    private final AtomicLong failureInWindow;
    private volatile long circuitOpened;

    LazyCircuitBreaker(CircuitBreakerConfig config) {
        if (!config.enabled()) {
            throw InvalidArgumentException.fromMessage("This CircuitBreaker always needs to be enabled");
        }
        this.config = config;
        this.state = new AtomicReference();
        this.rollingWindow = config.rollingWindow().toNanos();
        this.sleepingWindow = config.sleepWindow().toNanos();
        this.totalInWindow = new AtomicLong();
        this.failureInWindow = new AtomicLong();
        this.reset();
    }

    @Override
    public void track() {
        this.state.compareAndSet(CircuitBreaker.State.OPEN, CircuitBreaker.State.HALF_OPEN);
    }

    @Override
    public void reset() {
        long now = System.nanoTime();
        this.state.set(CircuitBreaker.State.CLOSED);
        this.circuitOpened = now - this.sleepingWindow;
        this.totalInWindow.set(0L);
        this.failureInWindow.set(0L);
        this.windowStartTimestamp = now - this.rollingWindow;
    }

    @Override
    public boolean allowsRequest() {
        CircuitBreaker.State state = this.state();
        if (state == CircuitBreaker.State.CLOSED) {
            return true;
        }
        boolean sleepingWindowElapsed = System.nanoTime() - this.circuitOpened > this.sleepingWindow;
        return state == CircuitBreaker.State.OPEN && sleepingWindowElapsed;
    }

    @Override
    public CircuitBreaker.State state() {
        return this.state.get();
    }

    private void cleanRollingWindow() {
        long now = System.nanoTime();
        if (now - this.windowStartTimestamp > this.rollingWindow) {
            this.windowStartTimestamp = now;
            this.totalInWindow.set(0L);
            this.failureInWindow.set(0L);
        }
    }

    private void checkIfTripped() {
        if (this.totalInWindow.get() < (long)this.config.volumeThreshold()) {
            return;
        }
        int percentThreshold = this.config.errorThresholdPercentage();
        long currentThreshold = (long)((float)this.failureInWindow.get() * 1.0f / (float)this.totalInWindow.get() * 100.0f);
        if (currentThreshold >= (long)percentThreshold) {
            this.state.set(CircuitBreaker.State.OPEN);
            this.circuitOpened = System.nanoTime();
        }
    }

    @Override
    public void markFailure() {
        long now = System.nanoTime();
        if (this.state.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.OPEN)) {
            this.circuitOpened = now;
        } else {
            this.cleanRollingWindow();
            this.totalInWindow.incrementAndGet();
            this.failureInWindow.incrementAndGet();
            this.checkIfTripped();
        }
    }

    @Override
    public void markSuccess() {
        if (this.state.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.CLOSED)) {
            this.reset();
        } else {
            this.cleanRollingWindow();
            this.totalInWindow.incrementAndGet();
        }
    }
}

