/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.endpoint.CircuitBreaker;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.HostAndPort;
import java.util.Map;
import java.util.Optional;

public class EndpointContext
extends CoreContext {
    private final HostAndPort remoteSocket;
    private final Optional<HostAndPort> localSocket;
    private final CircuitBreaker circuitBreaker;
    private final ServiceType serviceType;
    private final Optional<String> bucket;
    private final Optional<String> channelId;

    public EndpointContext(EndpointContext ctx) {
        this(ctx, ctx.remoteSocket, ctx.circuitBreaker, ctx.serviceType, ctx.localSocket, ctx.bucket, ctx.channelId);
    }

    public EndpointContext(CoreContext ctx, HostAndPort remoteSocket, CircuitBreaker circuitBreaker, ServiceType serviceType, Optional<HostAndPort> localSocket, Optional<String> bucket, Optional<String> channelId) {
        super(ctx.core(), ctx.id(), ctx.environment(), ctx.authenticator());
        this.remoteSocket = remoteSocket;
        this.circuitBreaker = circuitBreaker;
        this.serviceType = serviceType;
        this.bucket = bucket;
        this.localSocket = localSocket;
        this.channelId = channelId;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        input.put("remote", RedactableArgument.redactSystem(this.remoteSocket()));
        this.localSocket.ifPresent(s -> input.put("local", RedactableArgument.redactSystem(s)));
        if (this.circuitBreaker != null) {
            input.put("circuitBreaker", this.circuitBreaker.state().toString());
        }
        input.put("type", (Object)this.serviceType);
        this.bucket.ifPresent(b -> input.put("bucket", RedactableArgument.redactMeta(b)));
        this.channelId.ifPresent(i -> input.put("channelId", i));
    }

    public CircuitBreaker circuitBreaker() {
        return this.circuitBreaker;
    }

    public Optional<HostAndPort> localSocket() {
        return this.localSocket;
    }

    public HostAndPort remoteSocket() {
        return this.remoteSocket;
    }

    public ServiceType serviceType() {
        return this.serviceType;
    }

    public Optional<String> bucket() {
        return this.bucket;
    }

    public Optional<String> channelId() {
        return this.channelId;
    }
}

