/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.diagnostics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.core.diagnostics.EndpointPingReport;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.service.ServiceType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class PingResult {
    static final int VERSION = 2;
    private final Map<ServiceType, List<EndpointPingReport>> endpoints;
    private final String sdk;
    private final String id;

    @Stability.Internal
    public PingResult(Map<ServiceType, List<EndpointPingReport>> endpoints, String sdk, String id) {
        this.id = id == null ? UUID.randomUUID().toString() : id;
        this.endpoints = endpoints;
        this.sdk = sdk;
    }

    public String id() {
        return this.id;
    }

    public int version() {
        return 2;
    }

    public String sdk() {
        return this.sdk;
    }

    public Map<ServiceType, List<EndpointPingReport>> endpoints() {
        return this.endpoints;
    }

    public String exportToJson() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap services = new HashMap();
        for (Map.Entry<ServiceType, List<EndpointPingReport>> e : this.endpoints.entrySet()) {
            services.put(e.getKey().ident(), e.getValue().stream().map(EndpointPingReport::toMap).collect(Collectors.toList()));
        }
        result.put("version", 2);
        result.put("services", services);
        result.put("sdk", this.sdk);
        result.put("id", this.id);
        try {
            return Mapper.writer().writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            throw new EncodingFailureException("Could not encode report to JSON.", e);
        }
    }

    public String toString() {
        return "PingResult{endpoints=" + this.endpoints + ", version=" + 2 + ", sdk='" + this.sdk + '\'' + ", id='" + this.id + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PingResult that = (PingResult)o;
        return Objects.equals(this.endpoints, that.endpoints) && Objects.equals(this.sdk, that.sdk) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.endpoints, this.sdk, this.id);
    }
}

