/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.diagnostics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.endpoint.CircuitBreaker;
import com.couchbase.client.core.endpoint.EndpointState;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class EndpointDiagnostics {
    private final ServiceType type;
    private final EndpointState state;
    private final CircuitBreaker.State circuitBreakerState;
    private final String local;
    private final String remote;
    private final Optional<Long> lastActivityUs;
    private final Optional<String> id;
    private final Optional<String> namespace;
    private final Optional<Throwable> lastConnectAttemptFailure;

    @Stability.Internal
    public EndpointDiagnostics(ServiceType type, EndpointState state, CircuitBreaker.State circuitBreakerState, String local, String remote, Optional<String> namespace, Optional<Long> lastActivityUs, Optional<String> id, Optional<Throwable> lastConnectAttemptFailure) {
        this.type = type;
        this.state = state;
        this.circuitBreakerState = Objects.requireNonNull(circuitBreakerState);
        this.id = id;
        this.local = local;
        this.remote = remote;
        this.lastActivityUs = lastActivityUs;
        this.namespace = namespace;
        this.lastConnectAttemptFailure = lastConnectAttemptFailure;
    }

    public ServiceType type() {
        return this.type;
    }

    public Optional<String> id() {
        return this.id;
    }

    public String local() {
        return this.local;
    }

    public String remote() {
        return this.remote;
    }

    public Optional<Duration> lastActivity() {
        return this.lastActivityUs.map(a -> Duration.ofNanos(TimeUnit.MICROSECONDS.toNanos((long)a)));
    }

    public EndpointState state() {
        return this.state;
    }

    @Stability.Volatile
    public CircuitBreaker.State circuitBreakerState() {
        return this.circuitBreakerState;
    }

    public Optional<String> namespace() {
        return this.namespace;
    }

    @Stability.Volatile
    public Optional<Throwable> lastConnectAttemptFailure() {
        return this.lastConnectAttemptFailure;
    }

    Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.remote != null) {
            map.put("remote", this.remote);
        }
        if (this.local != null) {
            map.put("local", this.local);
        }
        map.put("state", this.state().name().toLowerCase(Locale.ROOT));
        map.put("circuit_breaker_state", this.circuitBreakerState().name().toLowerCase(Locale.ROOT));
        this.lastActivityUs.ifPresent(a -> map.put("last_activity_us", a));
        this.id.ifPresent(id -> map.put("id", id));
        this.namespace.ifPresent(n -> map.put("namespace", n));
        this.lastConnectAttemptFailure.ifPresent(e -> map.put("lastConnectAttemptFailure", e.getMessage()));
        return map;
    }

    public String toString() {
        return "EndpointDiagnostics{type=" + (Object)((Object)this.type) + ", state=" + (Object)((Object)this.state) + ", circuitBreakerState=" + (Object)((Object)this.circuitBreakerState) + ", local='" + this.local + '\'' + ", remote='" + this.remote + '\'' + ", lastActivityUs=" + this.lastActivityUs + ", id='" + this.id + '\'' + ", namespace=" + this.namespace + ", lastConnectAttemptFailure=" + (String)this.lastConnectAttemptFailure.map(Throwable::getMessage).orElse(null) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointDiagnostics that = (EndpointDiagnostics)o;
        return this.type == that.type && this.state == that.state && this.circuitBreakerState == that.circuitBreakerState && Objects.equals(this.local, that.local) && Objects.equals(this.remote, that.remote) && Objects.equals(this.lastActivityUs, that.lastActivityUs) && Objects.equals(this.id, that.id) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.lastConnectAttemptFailure, that.lastConnectAttemptFailure);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.state, this.circuitBreakerState, this.local, this.remote, this.lastActivityUs, this.id, this.namespace, this.lastConnectAttemptFailure});
    }
}

