/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.node.MemcachedHashingStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiFunction;

@Stability.Internal
public final class KetamaRing<E> {
    private final NavigableMap<Long, E> points;

    public static KetamaRing<NodeInfo> create(List<NodeInfo> nodes, MemcachedHashingStrategy strategy) {
        List<NodeInfo> kvNodes = CbCollections.filter(nodes, it -> it.services().containsKey((Object)ServiceType.KV));
        return new KetamaRing<NodeInfo>(kvNodes, strategy::hash);
    }

    KetamaRing(List<E> values, BiFunction<E, Integer, String> hashingStrategy) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("Ketama ring must have at least one value.");
        }
        TreeMap<Long, E> map = new TreeMap<Long, E>();
        MessageDigest md5 = KetamaRing.newMd5Digest();
        for (E value : values) {
            Objects.requireNonNull(value, "Ketama ring values must be non-null");
            for (int i = 0; i < 40; ++i) {
                String valueIdentifier = hashingStrategy.apply(value, i);
                byte[] md5Hash = md5.digest(valueIdentifier.getBytes(StandardCharsets.UTF_8));
                ByteBuf md5HashBuf = Unpooled.wrappedBuffer(md5Hash);
                while (md5HashBuf.isReadable()) {
                    long ketamaPoint = md5HashBuf.readUnsignedIntLE();
                    map.put(ketamaPoint, value);
                }
            }
        }
        KetamaRing.requireUint32((Long)map.firstKey());
        KetamaRing.requireUint32((Long)map.lastKey());
        this.points = Collections.unmodifiableNavigableMap(map);
    }

    public E get(byte[] key) {
        long ketamaHash = Unpooled.wrappedBuffer(KetamaRing.md5(key)).readUnsignedIntLE();
        return this.get(ketamaHash);
    }

    E get(long ketamaHash) {
        KetamaRing.requireUint32(ketamaHash);
        Map.Entry<Long, E> e = this.points.ceilingEntry(ketamaHash);
        return e != null ? e.getValue() : this.points.firstEntry().getValue();
    }

    NavigableMap<Long, E> toMap() {
        return this.points;
    }

    private static void requireUint32(long v) {
        if (v < 0L || v > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Expected a value that fits in an unsigned 32-bit integer, but got: " + v);
        }
    }

    private static MessageDigest newMd5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not calculate MD5 hash.", e);
        }
    }

    private static byte[] md5(byte[] message) {
        return KetamaRing.newMd5Digest().digest(message);
    }
}

