/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.xpack.sql.proto.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import shadow.fasterxml.jackson.core.JsonGenerator;
import shadow.fasterxml.jackson.core.JsonParser;
import shadow.org.elasticsearch.xpack.sql.proto.content.CborFactory;
import shadow.org.elasticsearch.xpack.sql.proto.content.JsonFactory;
import shadow.org.elasticsearch.xpack.sql.proto.content.ParsedMediaType;

public class ContentFactory {
    public static ContentType parseMediaType(String headerValue) {
        ParsedMediaType parsedMediaType = ParsedMediaType.parseMediaType(headerValue);
        if (parsedMediaType == null) {
            return null;
        }
        String parsedType = parsedMediaType.mediaTypeWithoutParameters();
        if (ContentType.JSON.mediaTypeWithoutParameters().equals(parsedType)) {
            return ContentType.JSON;
        }
        if (ContentType.CBOR.mediaTypeWithoutParameters().equals(parsedType)) {
            return ContentType.CBOR;
        }
        return null;
    }

    public static JsonParser parser(ContentType type, InputStream in) throws IOException {
        if (type == ContentType.JSON) {
            return JsonFactory.parser(in);
        }
        return CborFactory.parser(in);
    }

    public static JsonGenerator generator(ContentType type, OutputStream out) throws IOException {
        if (type == ContentType.JSON) {
            return JsonFactory.generator(out);
        }
        return CborFactory.generator(out);
    }

    public static enum ContentType {
        JSON{

            @Override
            public String mediaTypeWithoutParameters() {
                return "application/json";
            }
        }
        ,
        CBOR{

            @Override
            public String mediaTypeWithoutParameters() {
                return "application/cbor";
            }
        };


        public abstract String mediaTypeWithoutParameters();
    }
}

