/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.JDProperties;
import java.sql.SQLException;

class SQLConversionSettings {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    public static final int DATE_FORMAT_JULIAN = 0;
    public static final int DATE_FORMAT_MDY = 1;
    public static final int DATE_FORMAT_DMY = 2;
    public static final int DATE_FORMAT_YMD = 3;
    public static final int DATE_FORMAT_USA = 4;
    public static final int DATE_FORMAT_ISO = 5;
    public static final int DATE_FORMAT_EUR = 6;
    public static final int DATE_FORMAT_JIS = 7;
    public static final int TIME_FORMAT_HMS = 0;
    public static final int TIME_FORMAT_USA = 1;
    public static final int TIME_FORMAT_ISO = 2;
    public static final int TIME_FORMAT_EUR = 3;
    public static final int TIME_FORMAT_JIS = 4;
    private int dateFormat_;
    private String dateSeparator_;
    private String decimalSeparator_;
    private int maxFieldSize_;
    private int timeFormat_;
    private String timeSeparator_;
    private boolean useBigDecimal_;
    private int bidiStringType_;
    private boolean bidiImplicitReordering_;
    private boolean bidiNumericOrdering_;
    private boolean translateBoolean_;
    private static Object cachedConversionSettingsLock_ = new Object();
    private static SQLConversionSettings cachedConversionSettings_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SQLConversionSettings getConversionSettings(AS400JDBCConnection aS400JDBCConnection) throws SQLException {
        Object object = cachedConversionSettingsLock_;
        synchronized (object) {
            if (cachedConversionSettings_ != null && cachedConversionSettings_.matches(aS400JDBCConnection)) {
                return cachedConversionSettings_;
            }
            cachedConversionSettings_ = new SQLConversionSettings(aS400JDBCConnection);
            return cachedConversionSettings_;
        }
    }

    static SQLConversionSettings getConversionSettingsWithMaxFieldSize(SQLConversionSettings sQLConversionSettings, int n) {
        if (sQLConversionSettings.maxFieldSize_ == n) {
            return sQLConversionSettings;
        }
        return new SQLConversionSettings(sQLConversionSettings, n);
    }

    private SQLConversionSettings(AS400JDBCConnection aS400JDBCConnection) throws SQLException {
        JDProperties jDProperties = aS400JDBCConnection.getProperties();
        this.dateFormat_ = jDProperties.getIndex(3);
        this.dateSeparator_ = jDProperties.getString(4);
        this.decimalSeparator_ = jDProperties.getString(5);
        this.timeFormat_ = jDProperties.getIndex(24);
        this.timeSeparator_ = jDProperties.getString(25);
        this.bidiStringType_ = this.getInt(jDProperties.getString(42));
        this.bidiImplicitReordering_ = jDProperties.getBoolean(60);
        this.bidiNumericOrdering_ = jDProperties.getBoolean(61);
        if (this.dateSeparator_.equalsIgnoreCase("b")) {
            this.dateSeparator_ = " ";
        }
        if (this.timeSeparator_.equalsIgnoreCase("b")) {
            this.timeSeparator_ = " ";
        }
        this.maxFieldSize_ = 0;
        this.useBigDecimal_ = jDProperties.getBoolean(37);
        this.translateBoolean_ = jDProperties.getBoolean(71);
    }

    private SQLConversionSettings(SQLConversionSettings sQLConversionSettings, int n) {
        this.dateFormat_ = sQLConversionSettings.dateFormat_;
        this.dateSeparator_ = sQLConversionSettings.dateSeparator_;
        this.decimalSeparator_ = sQLConversionSettings.decimalSeparator_;
        this.timeFormat_ = sQLConversionSettings.timeFormat_;
        this.timeSeparator_ = sQLConversionSettings.timeSeparator_;
        this.bidiStringType_ = sQLConversionSettings.bidiStringType_;
        this.bidiImplicitReordering_ = sQLConversionSettings.bidiImplicitReordering_;
        this.bidiNumericOrdering_ = sQLConversionSettings.bidiNumericOrdering_;
        this.dateSeparator_ = sQLConversionSettings.dateSeparator_;
        this.timeSeparator_ = sQLConversionSettings.timeSeparator_;
        this.maxFieldSize_ = n;
        this.useBigDecimal_ = sQLConversionSettings.useBigDecimal_;
        this.translateBoolean_ = sQLConversionSettings.translateBoolean_;
    }

    private boolean stringRefsEqual(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private boolean matches(AS400JDBCConnection aS400JDBCConnection) throws SQLException {
        JDProperties jDProperties = aS400JDBCConnection.getProperties();
        if (this.dateFormat_ != jDProperties.getIndex(3)) {
            return false;
        }
        String string = this.dateSeparator_;
        if (string != null && string == " ") {
            string = "b";
        }
        if (!this.stringRefsEqual(string, jDProperties.getString(4))) {
            return false;
        }
        if (!this.stringRefsEqual(this.decimalSeparator_, jDProperties.getString(5))) {
            return false;
        }
        if (this.timeFormat_ != jDProperties.getIndex(24)) {
            return false;
        }
        String string2 = this.timeSeparator_;
        if (string2 != null && string2 == " ") {
            string2 = "b";
        }
        if (!this.stringRefsEqual(string2, jDProperties.getString(25))) {
            return false;
        }
        if (this.bidiStringType_ != this.getInt(jDProperties.getString(42))) {
            return false;
        }
        if (this.bidiImplicitReordering_ != jDProperties.getBoolean(60)) {
            return false;
        }
        if (this.bidiNumericOrdering_ != jDProperties.getBoolean(61)) {
            return false;
        }
        if (this.maxFieldSize_ != 0) {
            return false;
        }
        if (this.useBigDecimal_ != jDProperties.getBoolean(37)) {
            return false;
        }
        return this.translateBoolean_ == jDProperties.getBoolean(71);
    }

    int getInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    int getBidiStringType() {
        return this.bidiStringType_;
    }

    boolean getBidiImplicitReordering() {
        return this.bidiImplicitReordering_;
    }

    boolean getBidiNumericOrdering() {
        return this.bidiNumericOrdering_;
    }

    boolean getTranslateBoolean() {
        return this.translateBoolean_;
    }

    int getDateFormat() {
        return this.dateFormat_;
    }

    String getDateSeparator() {
        return this.dateSeparator_;
    }

    String getDecimalSeparator() {
        return this.decimalSeparator_;
    }

    int getMaxFieldSize() {
        return this.maxFieldSize_;
    }

    int getTimeFormat() {
        return this.timeFormat_;
    }

    String getTimeSeparator() {
        return this.timeSeparator_;
    }

    boolean useBigDecimal() {
        return this.useBigDecimal_;
    }
}

