/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDPrinter;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.PrinterImpl;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class Printer
extends PrintObject
implements Serializable {
    static final long serialVersionUID = 4L;
    private static boolean fAttrIDsToRtvBuilt_ = false;
    private static final String NAME = "name";

    Printer(AS400 aS400, NPCPIDPrinter nPCPIDPrinter, NPCPAttribute nPCPAttribute) {
        super(aS400, nPCPIDPrinter, nPCPAttribute, 3);
    }

    public Printer() {
        super(null, null, 3);
    }

    public Printer(AS400 aS400, String string) {
        super(aS400, new NPCPIDPrinter(string), null, 3);
        this.checkPrinterName(string);
    }

    void checkPrinterName(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'printerName' is null.");
            throw new NullPointerException("printerName");
        }
        if (string.length() > 10 || string.length() < 1) {
            Trace.log(2, "Parameter 'printerName' is greater than 10 or less than 1 characters in length " + string);
            throw new ExtendedIllegalArgumentException("printerName(" + string + ")", 1);
        }
    }

    void checkRunTimeState() {
        super.checkRunTimeState();
        if (this.getIDCodePoint() == null) {
            Trace.log(2, "Printer name has not been set.");
            throw new ExtendedIllegalStateException(NAME, 4);
        }
    }

    void chooseImpl() throws IOException, AS400SecurityException {
        AS400 aS400 = this.getSystem();
        if (aS400 == null) {
            Trace.log(2, "Attempt to use Printer before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrinterImpl)aS400.loadImpl2("com.ibm.as400.access.PrinterImplRemote", "com.ibm.as400.access.PrinterImplProxy");
        super.setImpl();
    }

    public String getName() {
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return "";
        }
        return nPCPID.getStringValue(89);
    }

    public void setAttributes(PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (printParameterList == null) {
            Trace.log(2, "Parameter 'attributes' is null.");
            throw new NullPointerException("attributes");
        }
        this.checkRunTimeState();
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((PrinterImpl)this.impl_).setAttributes(printParameterList);
        this.attrs = this.impl_.getAttrValue();
    }

    public void setName(String string) throws PropertyVetoException {
        this.checkPrinterName(string);
        String string2 = this.getName();
        this.vetos.fireVetoableChange(NAME, string2, string);
        this.setIDCodePoint(new NPCPIDPrinter(string));
        this.changes.firePropertyChange(NAME, string2, string);
    }
}

