/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse;

import com.google.gson.Gson;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.clickhouse.ClickhouseDataTypesLexer;
import org.jkiss.dbeaver.ext.clickhouse.ClickhouseDataTypesParser;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseArrayType;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseDataSource;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseMapType;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseTupleType;
import org.jkiss.dbeaver.ext.clickhouse.model.data.ClickhouseTupleValue;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeMap;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class ClickhouseTypeParser {
    private static final Log log = Log.getLog(ClickhouseTypeParser.class);
    private static final Gson gson = new Gson();

    private ClickhouseTypeParser() {
    }

    public static boolean isComplexType(@NotNull String typeName) {
        return typeName.startsWith("Map") || typeName.startsWith("Tuple") || typeName.startsWith("Array");
    }

    @Nullable
    public static Object makeValue(@NotNull DBCSession session, @NotNull String typeName, @Nullable Object object) throws DBException {
        DBSDataType type = ClickhouseTypeParser.getType(session.getProgressMonitor(), (ClickhouseDataSource)session.getDataSource(), typeName);
        if (type != null) {
            return ClickhouseTypeParser.makeValue(session, (DBSTypedObject)type, object);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Object makeValue(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object) throws DBException {
        if (object == null) {
            return null;
        }
        DBSTypedObject dBSTypedObject = type;
        if (dBSTypedObject instanceof ClickhouseMapType) {
            void map;
            ClickhouseMapType clickhouseMapType = (ClickhouseMapType)dBSTypedObject;
            ClickhouseMapType cfr_ignored_0 = (ClickhouseMapType)dBSTypedObject;
            return new JDBCCompositeMap(session, (DBSDataType)map, (Map)object);
        }
        DBSTypedObject dBSTypedObject2 = type;
        if (dBSTypedObject2 instanceof ClickhouseTupleType) {
            void tuple;
            ClickhouseTupleType clickhouseTupleType = (ClickhouseTupleType)dBSTypedObject2;
            ClickhouseTupleType cfr_ignored_1 = (ClickhouseTupleType)dBSTypedObject2;
            Object[] values = object instanceof Map ? ((Map)object).entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).toArray() : (object instanceof String ? JSONUtils.parseMap((Gson)gson, (Reader)new StringReader((String)object)).entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).toArray() : ((Collection)object).toArray());
            int i = 0;
            while (i < values.length) {
                values[i] = ClickhouseTypeParser.makeValue(session, (DBSTypedObject)tuple.getAttributes().get(i).getDataType(), values[i]);
                ++i;
            }
            return new ClickhouseTupleValue(session.getProgressMonitor(), (ClickhouseTupleType)tuple, values);
        }
        return object;
    }

    @Nullable
    public static DBSDataType getType(@NotNull DBRProgressMonitor monitor, @NotNull ClickhouseDataSource dataSource, @NotNull String typeName) throws DBException {
        ClickhouseDataTypesLexer lexer = new ClickhouseDataTypesLexer((CharStream)CharStreams.fromString((String)typeName));
        ClickhouseDataTypesParser parser = new ClickhouseDataTypesParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        ClickhouseDataTypesParser.AnyTypeContext type = parser.type().anyType();
        if (parser.getNumberOfSyntaxErrors() > 0) {
            log.debug((Object)("Rejecting invalid or unsupported type: " + typeName));
            return null;
        }
        Object resolved = type.simpleType() != null ? DBUtils.resolveDataType((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)type.simpleType().getText()) : (type.markerType() != null ? DBUtils.resolveDataType((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)type.markerType().anyType().getText()) : (type.tupleType() != null ? ClickhouseTypeParser.getTupleType(monitor, dataSource, type.tupleType()) : (type.mapType() != null ? ClickhouseTypeParser.getMapType(monitor, dataSource, type.mapType()) : (type.arrayType() != null ? ClickhouseTypeParser.getArrayType(monitor, dataSource, type.arrayType()) : null))));
        if (resolved == null) {
            log.debug((Object)("Can't resolve type for '" + typeName + "'"));
        }
        return resolved;
    }

    @Nullable
    private static DBSDataType getArrayType(@NotNull DBRProgressMonitor monitor, @NotNull ClickhouseDataSource dataSource, ClickhouseDataTypesParser.ArrayTypeContext type) throws DBException {
        DBSDataType componentType = ClickhouseTypeParser.getType(monitor, dataSource, type.anyType().getText());
        if (componentType == null) {
            return null;
        }
        return new ClickhouseArrayType(dataSource, componentType);
    }

    @Nullable
    private static DBSDataType getTupleType(@NotNull DBRProgressMonitor monitor, @NotNull ClickhouseDataSource dataSource, @NotNull ClickhouseDataTypesParser.TupleTypeContext context) throws DBException {
        ArrayList<CallSite> names = new ArrayList<CallSite>();
        ArrayList<DBSDataType> types = new ArrayList<DBSDataType>();
        if (context.tupleElementList() != null && context.tupleElementList().tupleElement() != null) {
            for (ClickhouseDataTypesParser.TupleElementContext element : context.tupleElementList().tupleElement()) {
                DBSDataType type = ClickhouseTypeParser.getType(monitor, dataSource, element.anyType().getText());
                if (type == null) {
                    return null;
                }
                names.add((CallSite)((Object)("Attr" + (names.size() + 1))));
                types.add(type);
            }
        }
        return new ClickhouseTupleType(dataSource, (DBSDataType[])types.toArray(DBSDataType[]::new), (String[])names.toArray(String[]::new));
    }

    @Nullable
    private static DBSDataType getMapType(@NotNull DBRProgressMonitor monitor, @NotNull ClickhouseDataSource dataSource, @NotNull ClickhouseDataTypesParser.MapTypeContext context) throws DBException {
        DBSDataType keyType = ClickhouseTypeParser.getType(monitor, dataSource, context.key.getText());
        DBSDataType valueType = ClickhouseTypeParser.getType(monitor, dataSource, context.value.getText());
        if (keyType == null || valueType == null) {
            return null;
        }
        return new ClickhouseMapType(dataSource, keyType, valueType);
    }

    @NotNull
    public static Map<String, Integer> tryParseEnumEntries(@NotNull String type) {
        if (!ClickhouseTypeParser.isEnum(type)) {
            return Collections.emptyMap();
        }
        CodePointCharStream input = CharStreams.fromString((String)type);
        ClickhouseDataTypesLexer ll = new ClickhouseDataTypesLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)ll);
        ClickhouseDataTypesParser pp = new ClickhouseDataTypesParser((TokenStream)tokens);
        ClickhouseDataTypesParser.EnumTypeContext tree = pp.enumType();
        if (tree.enumEntryList() != null && tree.enumEntryList().enumEntry() != null) {
            return tree.enumEntryList().enumEntry().stream().filter(node -> node != null && node.String() != null && node.Number() != null).map(node -> {
                String stringValue = node.String().getText();
                String key = stringValue.substring(1, stringValue.length() - 1);
                int val = CommonUtils.toInt((Object)node.Number().getText());
                return new Pair((Object)key, (Object)val);
            }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        }
        return Collections.emptyMap();
    }

    @NotNull
    public static String getTypeNameWithoutModifiers(@NotNull String fullTypeName) {
        int div = fullTypeName.indexOf(40);
        if (div < 0) {
            return fullTypeName;
        }
        return fullTypeName.substring(0, div);
    }

    private static boolean isEnum(@NotNull String type) {
        String name = type.toLowerCase();
        return name.startsWith("enum8(") || name.startsWith("enum16(");
    }
}

