/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.model;

import com.datastax.driver.core.IndexMetadata;
import com.datastax.driver.core.Metadata;
import com.dbeaver.db.ycql.model.CasTable;
import com.dbeaver.db.ycql.model.CasTableColumn;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;
import org.jkiss.utils.CommonUtils;

public class CasTableIndex
implements DBSTableIndex {
    private static final Log log = Log.getLog(CasTableIndex.class);
    private static final String WHERE_OPTION = "predicate";
    private static final String INCLUDE_OPTION = "include";
    private static final String ENABLED_OPTION = "enabled";
    private final String indexName;
    private final CasTable table;
    private final IndexMetadata metadata;
    private String query;
    private final boolean isUnique;
    private Map<String, String> options;
    private Map<String, String> transactions;
    private List<IndexColumn> indexColumns = new ArrayList<IndexColumn>();

    public CasTableIndex(@NotNull String indexName, @NotNull CasTable table, @NotNull IndexMetadata metadata, boolean isUnique, @NotNull Map<String, String> options, @NotNull Map<String, String> transactions) {
        this.indexName = indexName;
        this.table = table;
        this.metadata = metadata;
        this.isUnique = isUnique;
        this.options = options;
        this.transactions = transactions;
    }

    public CasTable getContainer() {
        return this.table;
    }

    public CasTable getTable() {
        return this.table;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean isPrimary() {
        return false;
    }

    public DBSIndexType getIndexType() {
        return DBSIndexType.CLUSTERED;
    }

    public List<IndexColumn> getAttributeReferences(DBRProgressMonitor monitor) {
        String target;
        if (CommonUtils.isEmpty(this.indexColumns) && CommonUtils.isNotEmpty((String)(target = this.metadata.getTarget()))) {
            try {
                if (target.contains(",")) {
                    String[] columnNames;
                    String[] stringArray = columnNames = target.split(",");
                    int n = columnNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        if (CommonUtils.isNotEmpty((String)name)) {
                            String finalName = name.contains(">>") && !name.startsWith(">>") ? name.substring(0, name.indexOf(">") - 1) : name.trim();
                            CasTableColumn attribute = this.table.getAttribute(monitor, finalName);
                            this.indexColumns.add(new IndexColumn(attribute));
                        }
                        ++n2;
                    }
                } else {
                    CasTableColumn attribute = this.table.getAttribute(monitor, target);
                    this.indexColumns.add(new IndexColumn(attribute));
                }
            }
            catch (DBException e) {
                log.warn((Object)("Can't find index '" + target + "' column"), (Throwable)e);
            }
        }
        return this.indexColumns;
    }

    public String getDescription() {
        return null;
    }

    @NotNull
    public DBSEntity getParentObject() {
        return this.table;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.table.getDataSource();
    }

    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return DBSEntityConstraintType.INDEX;
    }

    @NotNull
    public String getName() {
        return this.indexName;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return this.getName();
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=100)
    public String getQuery() {
        if (CommonUtils.isEmpty((String)this.query)) {
            this.query = this.asCQLQuery();
        }
        return this.query;
    }

    private String asCQLQuery() {
        String whereOption;
        String keyspaceName = Metadata.quoteIfNecessary((String)this.table.getKeyspace().getName());
        String tableName = Metadata.quoteIfNecessary((String)this.table.getName());
        String indexName = Metadata.quoteIfNecessary((String)this.metadata.getName());
        if (this.metadata.isCustomIndex()) {
            return String.format("CREATE CUSTOM INDEX %s ON %s.%s (%s) USING '%s' %s;", indexName, keyspaceName, tableName, this.metadata.getTarget(), this.metadata.getIndexClassName(), this.getOptionsAsCql());
        }
        StringBuilder ddl = new StringBuilder(64);
        ddl.append("CREATE ");
        if (this.isUnique) {
            ddl.append("UNIQUE");
        }
        ddl.append(" INDEX ").append(indexName).append(this.table.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ON (").append(this.metadata.getTarget()).append(")");
        String includeOption = this.metadata.getOption(INCLUDE_OPTION);
        if (CommonUtils.isNotEmpty((String)includeOption)) {
            ddl.append(" INCLUDE (").append(includeOption).append(")");
        }
        if (CommonUtils.isNotEmpty((String)(whereOption = this.metadata.getOption(WHERE_OPTION)))) {
            ddl.append(" WHERE ").append(whereOption);
        }
        if (!CommonUtils.isEmpty(this.transactions)) {
            ddl.append(" WITH transactions = {");
            boolean first = true;
            for (Map.Entry<String, String> entry : this.transactions.entrySet()) {
                if (!first) {
                    ddl.append(",");
                } else {
                    first = false;
                }
                if (ENABLED_OPTION.equals(entry.getKey())) {
                    ddl.append("'enabled' : ").append(entry.getValue());
                    continue;
                }
                ddl.append("'").append(entry.getKey()).append("' : '").append(entry.getValue()).append("'");
            }
            ddl.append("}");
        }
        return ddl.toString();
    }

    private String getOptionsAsCql() {
        Iterable filtered = this.options.entrySet().stream().filter(input -> !((String)input.getKey()).equals("target") && !((String)input.getKey()).equals("class_name")).collect(Collectors.toList());
        if (Iterables.isEmpty((Iterable)filtered)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("WITH OPTIONS = {");
        Iterator it = filtered.iterator();
        while (it.hasNext()) {
            Map.Entry option = (Map.Entry)it.next();
            builder.append(String.format("'%s' : '%s'", option.getKey(), option.getValue()));
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    public class IndexColumn
    implements DBSTableIndexColumn {
        private final CasTableColumn column;

        public IndexColumn(CasTableColumn column) {
            this.column = column;
        }

        @NotNull
        public DBSEntityAttribute getAttribute() {
            return this.column;
        }

        public DBSObject getParentObject() {
            return CasTableIndex.this;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return CasTableIndex.this.getDataSource();
        }

        @Property(viewable=true, editable=true, order=1)
        @NotNull
        public String getName() {
            return this.column.getName();
        }

        public boolean isPersisted() {
            return true;
        }

        public String getDescription() {
            return null;
        }

        @NotNull
        public DBSTableIndex getIndex() {
            return CasTableIndex.this;
        }

        public int getOrdinalPosition() {
            return 0;
        }

        public boolean isAscending() {
            return false;
        }

        @Nullable
        public DBSTableColumn getTableColumn() {
            return this.column;
        }
    }
}

