/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.model;

import com.dbeaver.db.ycql.model.CasDataSource;
import com.dbeaver.db.ycql.model.CasPrivilege;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.access.DBAPrivilegeGrant;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CasPrivilegeGrant
implements DBAPrivilegeGrant,
DBSObject {
    private final CasDataSource dataSource;
    private String userName;
    private String resourceName;
    private CasPrivilege[] privileges;

    public CasPrivilegeGrant(CasDataSource dataSource, String userName, String resourceName, String permission) {
        this.dataSource = dataSource;
        this.userName = userName;
        this.resourceName = resourceName;
        this.privileges = new CasPrivilege[]{dataSource.getPrivilege(permission)};
    }

    @Property(viewable=true, order=1)
    public Object getSubject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.userName;
    }

    @Property(viewable=true, order=2)
    public Object getObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.resourceName;
    }

    @Property(viewable=true, order=3)
    public CasPrivilege[] getPrivileges() {
        return this.privileges;
    }

    public boolean isGranted() {
        return true;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public String getName() {
        return this.privileges[0].getName();
    }

    public boolean isPersisted() {
        return true;
    }
}

