/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.model;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Session;
import com.dbeaver.db.ycql.exec.CasSession;
import com.dbeaver.db.ycql.model.CasDataSource;
import com.dbeaver.db.ycql.model.CasKeyspace;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCCachedContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class CasExecutionContext
extends AbstractExecutionContext<CasDataSource>
implements DBCExecutionContextDefaults<CasKeyspace, DBSSchema> {
    private static final Log log = Log.getLog(CasExecutionContext.class);
    private Session session;
    private ConsistencyLevel currentConsistencyLevel = ConsistencyLevel.ONE;
    private String selectedKeyspace;

    public CasExecutionContext(CasDataSource dataSource, String purpose, String selectedKeyspace) {
        super((DBPDataSource)dataSource, purpose);
        this.selectedKeyspace = selectedKeyspace;
    }

    public Session getSession() {
        return this.session;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((CasDataSource)this.dataSource).getContainer());
        try {
            try {
                monitor.subTask("Open cluster session");
                this.reconnect();
                this.initContextBootstrap(monitor, true);
                ((CasDataSource)this.dataSource).addExecutionContext((DBCExecutionContext)this);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((CasDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public CasSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new CasSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateContext(@NotNull DBRProgressMonitor monitor, @NotNull DBCInvalidatePhase phase) throws DBException {
        if (phase == DBCInvalidatePhase.BEFORE_INVALIDATE) {
            CasExecutionContext casExecutionContext = this;
            synchronized (casExecutionContext) {
                if (this.session != null) {
                    this.session.close();
                    this.session = null;
                }
            }
        }
        if (phase == DBCInvalidatePhase.INVALIDATE) {
            ((CasDataSource)this.dataSource).configureCluster(monitor);
            this.reconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        CasExecutionContext casExecutionContext = this;
        synchronized (casExecutionContext) {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            super.closeContext();
        }
        ((CasDataSource)this.dataSource).removeExecutionContext((DBCExecutionContext)this);
    }

    public void reconnect() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        this.session = CommonUtils.isEmpty((String)this.selectedKeyspace) ? ((CasDataSource)this.dataSource).getCluster().connect() : ((CasDataSource)this.dataSource).getCluster().connect(DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)this.selectedKeyspace));
        String defCL = ((CasDataSource)this.dataSource).getContainer().getActualConnectionConfiguration().getProviderProperty("@dbeaver-default.consistency.level@");
        if (!CommonUtils.isEmpty((String)defCL)) {
            try {
                this.currentConsistencyLevel = ConsistencyLevel.valueOf((String)defCL);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.debug((Object)("Bad default consistency level: " + defCL));
            }
        }
    }

    public ConsistencyLevel getCurrentConsistencyLevel() {
        return this.currentConsistencyLevel;
    }

    public void setCurrentConsistencyLevel(ConsistencyLevel currentConsistencyLevel) {
        this.currentConsistencyLevel = currentConsistencyLevel;
    }

    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return this;
    }

    public String getSelectedKeyspace() {
        return this.selectedKeyspace;
    }

    public CasKeyspace getDefaultCatalog() {
        return ((CasDataSource)this.getDataSource()).getKeyspace(this.selectedKeyspace);
    }

    public DBSSchema getDefaultSchema() {
        return null;
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public boolean supportsSchemaChange() {
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, CasKeyspace keyspace, DBSSchema schema) throws DBCException {
        CasKeyspace oldSelectedEntity = this.getDefaultCatalog();
        if (oldSelectedEntity == keyspace) {
            return;
        }
        this.selectedKeyspace = keyspace.getName();
        this.reconnect();
        DBUtils.fireObjectSelectionChange((DBSObject)oldSelectedEntity, (DBSObject)keyspace, (DBCExecutionContext)this);
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, DBSSchema schema) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        return true;
    }

    @NotNull
    public DBCCachedContextDefaults getCachedDefault() {
        return new DBCCachedContextDefaults(this.selectedKeyspace, null);
    }
}

