/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.data.handlers;

import com.datastax.driver.core.DataType;
import com.dbeaver.db.ycql.data.handlers.CasBooleanValueHandler;
import com.dbeaver.db.ycql.data.handlers.CasContentValueHandler;
import com.dbeaver.db.ycql.data.handlers.CasInetValueHandler;
import com.dbeaver.db.ycql.data.handlers.CasListValueHandler;
import com.dbeaver.db.ycql.data.handlers.CasMapValueHandler;
import com.dbeaver.db.ycql.data.handlers.CasNumberValueHandler;
import com.dbeaver.db.ycql.data.handlers.CasSetValueHandler;
import com.dbeaver.db.ycql.data.handlers.CasStringValueHandler;
import com.dbeaver.db.ycql.data.handlers.CasTimestampValueHandler;
import com.dbeaver.db.ycql.data.handlers.CasTupleValueHandler;
import com.dbeaver.db.ycql.data.handlers.CasUDTValueHandler;
import com.dbeaver.db.ycql.data.handlers.CasUUIDValueHandler;
import com.dbeaver.db.ycql.model.CasTypedObject;
import java.util.Locale;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasValueHandlerProvider
implements DBDValueHandlerProvider {
    private static final Log log = Log.getLog(CasValueHandlerProvider.class);

    @Nullable
    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDFormatSettings preferences, DBSTypedObject typedObject) {
        DataType.Name typeName;
        if (typedObject instanceof CasTypedObject) {
            typeName = ((CasTypedObject)typedObject).getCasDataType().getName();
        } else {
            try {
                typeName = DataType.Name.valueOf((String)typedObject.getTypeName().toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {
                log.debug((Object)("Unknown YCQL data type: " + typedObject.getTypeName()));
                return CasContentValueHandler.INSTANCE;
            }
        }
        switch (typeName) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return CasStringValueHandler.INSTANCE;
            }
            case BIGINT: 
            case COUNTER: 
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case VARINT: 
            case SMALLINT: 
            case TINYINT: {
                return new CasNumberValueHandler(typedObject, typeName, preferences);
            }
            case BOOLEAN: {
                return CasBooleanValueHandler.INSTANCE;
            }
            case TIMESTAMP: 
            case DATE: 
            case TIME: {
                return new CasTimestampValueHandler(preferences);
            }
            case UUID: 
            case TIMEUUID: {
                return CasUUIDValueHandler.INSTANCE;
            }
            case INET: {
                return CasInetValueHandler.INSTANCE;
            }
            case MAP: {
                return CasMapValueHandler.INSTANCE;
            }
            case TUPLE: {
                return CasTupleValueHandler.INSTANCE;
            }
            case UDT: {
                return CasUDTValueHandler.INSTANCE;
            }
            case LIST: {
                return CasListValueHandler.INSTANCE;
            }
            case SET: {
                return CasSetValueHandler.INSTANCE;
            }
        }
        return CasContentValueHandler.INSTANCE;
    }
}

