/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.data.handlers;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.dbeaver.db.ycql.CasUtils;
import com.dbeaver.db.ycql.exec.CasPreparedStatement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.data.DateTimeCustomValueHandler;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasTimestampValueHandler
extends DateTimeCustomValueHandler {
    public CasTimestampValueHandler(DBDFormatSettings formatSettings) {
        super(formatSettings);
    }

    @NotNull
    public String getFormatterId(DBSTypedObject column) {
        if (column.getTypeID() == CasUtils.getTypeNameID(DataType.Name.DATE)) {
            return "date";
        }
        if (column.getTypeID() == CasUtils.getTypeNameID(DataType.Name.TIME)) {
            return "time";
        }
        return "timestamp";
    }

    public Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        return resultSet.getAttributeValue(index);
    }

    public final void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject columnMetaData, int index, Object value) throws DBCException {
        try {
            Object dateValue = this.getValueFromObject(session, columnMetaData, value, false, false);
            int dataTypeId = columnMetaData.getTypeID();
            BoundStatement boundStat = ((CasPreparedStatement)statement).getBoundStatement();
            if (dateValue == null) {
                boundStat.setToNull(index);
            } else if (dataTypeId == CasUtils.getTypeNameID(DataType.Name.DATE)) {
                if (dateValue instanceof Number) {
                    boundStat.setDate(index, CasUtils.toLocalDate(new Date(((Number)dateValue).longValue())));
                } else if (dateValue instanceof LocalDate) {
                    boundStat.setDate(index, (LocalDate)dateValue);
                } else if (dateValue instanceof Date) {
                    boundStat.setDate(index, CasUtils.toLocalDate((Date)dateValue));
                }
            } else if (dataTypeId == CasUtils.getTypeNameID(DataType.Name.TIME)) {
                if (dateValue instanceof Number) {
                    boundStat.setTime(index, ((Number)dateValue).longValue());
                } else if (dateValue instanceof Date) {
                    boundStat.setTime(index, CasUtils.toCasTime((Date)dateValue));
                }
            } else if (dateValue instanceof Number) {
                boundStat.setTimestamp(index, new Date(((Number)dateValue).longValue()));
            } else if (dateValue instanceof Date) {
                boundStat.setTimestamp(index, (Date)dateValue);
            }
        }
        catch (Exception e) {
            throw new DBCException("Error binding statement parameter", (Throwable)e);
        }
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof Number || object instanceof Date || object instanceof LocalDate) {
            return object;
        }
        if (object instanceof String) {
            Object date;
            try {
                date = this.getFormatter(type).parseValue((String)object, null);
            }
            catch (ParseException parseException) {
                log.debug((Object)("Unsupported YCQL date/time value: " + String.valueOf(object)));
                return object;
            }
            if (date == null) {
                return null;
            }
            if (date instanceof Date) {
                if (type.getTypeID() == CasUtils.getTypeNameID(DataType.Name.TIME)) {
                    return CasUtils.toCasTime((Date)date);
                }
                if (type.getTypeID() == CasUtils.getTypeNameID(DataType.Name.DATE)) {
                    return CasUtils.toLocalDate((Date)date);
                }
                return date;
            }
        }
        throw new DBCException("Unsupported YCQL date/time value: " + String.valueOf(object));
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (column instanceof DBSObject && this.formatSettings.isUseNativeDateTimeFormat()) {
            return DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)format);
        }
        if (value instanceof LocalDate) {
            LocalDate ldv = (LocalDate)value;
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, ldv.getYear());
            calendar.set(2, ldv.getMonth() - 1);
            calendar.set(5, ldv.getDay());
            value = calendar.getTime();
        } else if (value instanceof Number) {
            if (column.getTypeID() == CasUtils.getTypeNameID(DataType.Name.TIME)) {
                long nanos = ((Number)value).longValue();
                Timestamp timestamp = new Timestamp(nanos / 1000000L - (long)TimeZone.getDefault().getRawOffset());
                timestamp.setNanos((int)(nanos % 1000000L));
                value = timestamp;
            } else {
                value = new Date(((Number)value).longValue());
            }
        }
        return super.getValueDisplayString(column, value, format);
    }
}

