/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.dialog;

import com.dbeaver.db.redis.RedisMessages;
import com.dbeaver.db.redis.model.RedisKeyType;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class EnterKeyDialog
extends BaseDialog {
    private String name;
    private RedisKeyType type;
    private String value;
    private Text nameText;
    private Combo labelCombo;
    private Text valueText;
    private Text timeToLiveText;
    private CLabel errorLabel;
    private int ttl = -1;

    public EnterKeyDialog(@NotNull Shell activeWorkbenchShell) {
        super(activeWorkbenchShell, RedisMessages.dialog_create_key_title, null);
    }

    protected Composite createDialogArea(@NotNull Composite parent) {
        Composite composite = super.createDialogArea(parent);
        GridData gridData = new GridData(768);
        gridData.widthHint = UIUtils.getFontHeight((Font)composite.getFont()) * 40;
        Group groupCentral = UIUtils.createControlGroup((Composite)composite, (String)RedisMessages.dialog_create_key_group_general, (int)2, (int)768, (int)0);
        groupCentral.setLayoutData((Object)gridData);
        this.nameText = UIUtils.createLabelText((Composite)groupCentral, (String)RedisMessages.dialog_create_key_label_key_name, (String)"");
        this.nameText.addModifyListener(e -> {
            this.name = this.nameText.getText().trim();
            this.updateDialogCompletion();
        });
        this.labelCombo = UIUtils.createLabelCombo((Composite)groupCentral, (String)RedisMessages.dialog_create_key_label_key_type, (int)8);
        this.labelCombo.addModifyListener(e -> {
            this.type = RedisKeyType.valueOf((String)this.labelCombo.getText());
            this.updateDialogCompletion();
        });
        RedisKeyType[] redisKeyTypeArray = RedisKeyType.values();
        int n = redisKeyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RedisKeyType value = redisKeyTypeArray[n2];
            if (value.isValid()) {
                this.labelCombo.add(value.toString());
            }
            ++n2;
        }
        Group groupBottom = UIUtils.createControlGroup((Composite)composite, (String)RedisMessages.dialog_create_key_label_key_value, (int)1, (int)768, (int)0);
        Composite container = new Composite((Composite)groupBottom, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        container.setLayoutData((Object)new GridData(1808));
        GridData gd = new GridData(1808);
        gd.heightHint = UIUtils.getFontHeight((Font)container.getFont()) * 12;
        this.valueText = new Text(container, 2562);
        this.valueText.setLayoutData((Object)gd);
        this.valueText.addModifyListener(e -> {
            this.value = this.valueText.getText();
            this.updateDialogCompletion();
        });
        this.timeToLiveText = UIUtils.createLabelText((Composite)groupCentral, (String)RedisMessages.dialog_create_key_ttl_label, (String)"-1");
        this.timeToLiveText.setToolTipText(RedisMessages.dialog_create_key_ttl_tooltip);
        this.timeToLiveText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.timeToLiveText.addModifyListener(e -> {
            int n = this.ttl = CommonUtils.toInt((Object)this.timeToLiveText.getText(), (int)-1);
        });
        this.errorLabel = new CLabel(container, 0);
        this.errorLabel.setLayoutData((Object)new GridData(768));
        this.errorLabel.setVisible(false);
        UIUtils.asyncExec(this::updateDialogCompletion);
        return composite;
    }

    private void updateDialogCompletion() {
        this.getButton(0).setEnabled(this.type != null && this.checkValueValidity() && !CommonUtils.isEmpty((String)this.name));
    }

    private boolean checkValueValidity() {
        if (CommonUtils.isEmpty((String)this.value)) {
            boolean isString = this.type == RedisKeyType.string;
            this.setStatus(!isString, isString ? "" : "This type does not support empty values");
            return isString;
        }
        String[] strings = (String[])RuntimeUtils.splitCommandLine((String)this.value, (boolean)false).toArray(String[]::new);
        if (this.type == RedisKeyType.hash || this.type == RedisKeyType.zset) {
            if (Arrays.stream(strings).anyMatch(CommonUtils::isEmpty)) {
                this.setStatus(true, "This type does not support empty values");
                return false;
            }
            if (strings.length % 2 != 0) {
                this.setStatus(true, "Count of parameters is not even");
                return false;
            }
            if (this.type == RedisKeyType.zset) {
                int n = 1;
                while (n < strings.length) {
                    if (Double.isNaN(CommonUtils.toDouble((Object)strings[n]))) {
                        this.setStatus(true, "Wrong value format " + n);
                        return false;
                    }
                    n += 2;
                }
            }
        }
        this.setStatus(false, "");
        return true;
    }

    private void setStatus(boolean error, String message) {
        this.getButton(0).setEnabled(!error);
        this.errorLabel.setVisible(!message.isEmpty());
        if (!message.isEmpty()) {
            this.errorLabel.setImage(DBeaverIcons.getImage((DBPImage)(error ? DBIcon.SMALL_ERROR : DBIcon.SMALL_INFO)));
            this.errorLabel.setText(message);
        }
    }

    @NotNull
    public RedisKeyType getType() {
        return this.type;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public int getTTL() {
        return this.ttl;
    }
}

