/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.configurator;

import com.dbeaver.db.redis.RedisMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.utils.CommonUtils;

public class RedisMultiPasswordConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private Text nodePasswordText;

    public void createControl(@NotNull Composite authPanel, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        super.createControl(authPanel, object, propertyChangeListener);
        UIUtils.createControlLabel((Composite)authPanel, (String)RedisMessages.connection_page_auth_sentinel_password_label);
        Composite ph = UIUtils.createPlaceholder((Composite)authPanel, (int)1);
        ph.setLayoutData((Object)new GridData(32));
        this.nodePasswordText = new Text(ph, 0x400800);
        this.nodePasswordText.setToolTipText(RedisMessages.connection_page_auth_sentinel_password_tip);
        int fontHeight = UIUtils.getFontHeight((Control)authPanel);
        GridData gd = new GridData(32);
        gd.widthHint = fontHeight * 20;
        this.nodePasswordText.setLayoutData((Object)gd);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        String nodePassword = dataSource.getConnectionConfiguration().getAuthProperty("redis.sentinel.master.password");
        if (nodePassword != null) {
            this.nodePasswordText.setText(nodePassword);
        }
    }

    protected String getPasswordFieldLabel() {
        return RedisMessages.connection_page_auth_node_password;
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        if (!CommonUtils.isEmpty((String)this.nodePasswordText.getText())) {
            dataSource.getConnectionConfiguration().setAuthProperty("redis.sentinel.master.password", this.nodePasswordText.getText());
        } else {
            dataSource.getConnectionConfiguration().setAuthProperty("redis.sentinel.master.password", null);
        }
    }
}

