/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.ui.config;

import com.dbeaver.db.teradata.ui.TeradataMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class TeradataLDAPAuthConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private Text ldapExtraData;

    public void createControl(@NotNull Composite authPanel, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        this.usernameLabel = UIUtils.createLabel((Composite)authPanel, (String)UIConnectionMessages.dialog_connection_auth_label_username);
        this.usernameLabel.setLayoutData((Object)new GridData(32));
        this.createUserNameControls(authPanel, propertyChangeListener);
        this.createPasswordControls(authPanel, propertyChangeListener);
        this.ldapExtraData = UIUtils.createLabelTextAdvanced((Composite)authPanel, (String)TeradataMessages.auth_configurator_LDAP_extra_info_label, (String)"", (int)2048);
        this.ldapExtraData.setToolTipText(TeradataMessages.auth_configurator_LDAP_extra_info_tip);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.ldapExtraData != null && !this.ldapExtraData.isDisposed()) {
            this.ldapExtraData.setText(CommonUtils.notEmpty((String)connectionInfo.getProviderProperty("ldap_extra_info@")));
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.ldapExtraData != null && !this.ldapExtraData.isDisposed()) {
            connectionInfo.setProviderProperty("ldap_extra_info@", this.ldapExtraData.getText().trim());
        }
        connectionInfo.setProviderProperty("use_ldap_mechanism@", Boolean.TRUE.toString());
    }
}

