/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model.data;

import com.dbeaver.db.bigquery.model.data.BigQueryRoutineParameter;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public class BigQueryRoutine
extends GenericProcedure {
    private GenericCatalog catalog;
    private GenericSchema schema;
    private String createdTime;
    private String lastAlteredTime;
    private String ddl;
    private String extLang;
    private String body;

    public BigQueryRoutine(@NotNull GenericStructContainer container, @NotNull String name, @NotNull String description, @NotNull DBSProcedureType procedureType, @NotNull String source, boolean persisted) {
        super(container, name, description, procedureType, source, persisted);
    }

    public BigQueryRoutine(@NotNull GenericCatalog catalog, @NotNull GenericSchema schema, @NotNull String name, @Nullable String description, @NotNull String createdTime, @NotNull String lastAlteredTime, @NotNull String ddl, @Nullable String extLang, @NotNull DBSProcedureType type, @Nullable String source, boolean persisted) {
        super((GenericStructContainer)catalog, name, description, type, ddl, persisted);
        this.catalog = catalog;
        this.schema = schema;
        this.createdTime = createdTime;
        this.lastAlteredTime = lastAlteredTime;
        this.ddl = ddl;
        this.extLang = extLang;
        this.body = source;
    }

    @Property(viewable=true, order=1)
    public GenericCatalog getCatalog() {
        return this.catalog;
    }

    @Property(viewable=true, order=2)
    public GenericSchema getSchema() {
        return this.schema;
    }

    @Property(viewable=true, order=3)
    public String getCreatedTime() {
        return this.createdTime;
    }

    @Property(viewable=true, order=4)
    public String getLastAlteredTime() {
        return this.lastAlteredTime;
    }

    @Property(hidden=true)
    public GenericFunctionResultType getFunctionResultType() {
        return super.getFunctionResultType();
    }

    @Property(hidden=true)
    public GenericPackage getPackage() {
        return super.getPackage();
    }

    public String getDDL() {
        return this.ddl;
    }

    public String getExtLang() {
        return this.extLang;
    }

    @Property(viewable=true, order=6)
    public String getBodyExtLang() {
        return this.body;
    }

    public void loadProcedureColumns(DBRProgressMonitor monitor) throws DBException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load procedure columns");){
            try {
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + DBUtils.getQuotedIdentifier((DBSObject)this.getCatalog()) + "." + DBUtils.getQuotedIdentifier((DBSObject)this.getSchema()) + ".INFORMATION_SCHEMA.PARAMETERS WHERE SPECIFIC_NAME = ?");){
                    dbStat.setString(1, this.name);
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            DBSProcedureParameterKind parameterType;
                            String isAggregate;
                            String parameterDefault;
                            String isResult;
                            String parameterName;
                            String parameterMode;
                            String dateType;
                            String position;
                            String name;
                            block59: {
                                block57: {
                                    name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SPECIFIC_NAME");
                                    position = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ORDINAL_POSITION");
                                    dateType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATA_TYPE");
                                    parameterMode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARAMETER_MODE");
                                    parameterName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARAMETER_NAME");
                                    isResult = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IS_RESULT");
                                    parameterDefault = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARAMETER_DEFAULT");
                                    isAggregate = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IS_AGGREGATE");
                                    parameterType = DBSProcedureParameterKind.UNKNOWN;
                                    if (parameterMode == null) break block57;
                                    switch (parameterMode) {
                                        case "IN": {
                                            parameterType = DBSProcedureParameterKind.IN;
                                            break;
                                        }
                                        case "OUT": {
                                            parameterType = DBSProcedureParameterKind.OUT;
                                            break;
                                        }
                                        case "INOUT": {
                                            parameterType = DBSProcedureParameterKind.INOUT;
                                            break;
                                        }
                                        case "NULL": {
                                            parameterType = DBSProcedureParameterKind.UNKNOWN;
                                            break;
                                        }
                                        default: {
                                            parameterType = DBSProcedureParameterKind.UNKNOWN;
                                            break;
                                        }
                                    }
                                    break block59;
                                }
                                switch (isResult) {
                                    case "YES": {
                                        parameterType = DBSProcedureParameterKind.RETURN;
                                        break;
                                    }
                                    case "NO": {
                                        parameterType = DBSProcedureParameterKind.IN;
                                        break;
                                    }
                                    default: {
                                        parameterType = DBSProcedureParameterKind.UNKNOWN;
                                    }
                                }
                            }
                            BigQueryRoutineParameter parameter = new BigQueryRoutineParameter(this, name, position, dateType, parameterMode, parameterName, isResult, parameterDefault, isAggregate, parameterType);
                            this.addColumn(parameter);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e, this.getDataSource());
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }
}

