/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model;

import com.dbeaver.db.bigquery.model.BigQuerySchema;
import com.dbeaver.db.bigquery.model.BigQueryTableColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class BigQueryTable
extends GenericTable
implements DBPImageProvider {
    private boolean isClustered;

    public BigQueryTable(@NotNull GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
    }

    @Property(viewable=true, order=5)
    public boolean isClustered() {
        return this.isClustered;
    }

    public void setClustered(boolean clustered) {
        this.isClustered = clustered;
    }

    public BigQuerySchema getSchema() {
        return (BigQuerySchema)super.getSchema();
    }

    @Nullable
    public DBPImage getObjectImage() {
        return this.isClustered ? DBIcon.TREE_TABLE_INDEX : DBIcon.TREE_TABLE;
    }

    /*
     * WARNING - void declaration
     */
    public List<BigQueryTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        List attributes = super.getAttributes(monitor);
        if (attributes == null) {
            return Collections.emptyList();
        }
        ArrayList<BigQueryTableColumn> columns = new ArrayList<BigQueryTableColumn>();
        for (GenericTableColumn attribute : attributes) {
            void bigQueryColumn;
            GenericTableColumn genericTableColumn = attribute;
            if (!(genericTableColumn instanceof BigQueryTableColumn)) continue;
            BigQueryTableColumn cfr_ignored_0 = (BigQueryTableColumn)genericTableColumn;
            BigQueryTableColumn cfr_ignored_1 = (BigQueryTableColumn)genericTableColumn;
            columns.add((BigQueryTableColumn)bigQueryColumn);
        }
        columns.sort(DBUtils.orderComparator());
        return columns;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.refreshObject(monitor);
    }

    @Nullable
    public List<GenericUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getConstraints(monitor);
    }

    public Collection<? extends GenericTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getAssociations(monitor);
    }
}

