/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model;

import com.dbeaver.db.bigquery.model.BigQueryTable;
import com.dbeaver.db.bigquery.model.data.BigQueryRoutine;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class BigQuerySchema
extends GenericSchema {
    private static final Log log = Log.getLog(BigQuerySchema.class);
    private boolean clusteredTableStatusLoaded;

    public BigQuerySchema(@NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog, @NotNull String schemaName) {
        super(dataSource, catalog, schemaName);
    }

    public List<? extends GenericTable> getPhysicalTables(DBRProgressMonitor monitor) throws DBException {
        List tables = super.getPhysicalTables(monitor);
        GenericCatalog catalog = this.getCatalog();
        GenericSchema schema = this.getSchema();
        if (catalog != null && schema != null && !CommonUtils.isEmpty((Collection)tables) && !this.clusteredTableStatusLoaded) {
            this.markClusteredTables(monitor, catalog, schema, tables);
        }
        return tables;
    }

    /*
     * WARNING - void declaration
     */
    private void markClusteredTables(@NotNull DBRProgressMonitor monitor, @NotNull GenericCatalog catalog, @NotNull GenericSchema schema, @NotNull List<? extends GenericTable> tables) throws DBCException {
        ArrayList<String> clusteredTableNames = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read clustered table status");){
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT DISTINCT table_name FROM " + DBUtils.getQuotedIdentifier((DBSObject)catalog) + "." + DBUtils.getQuotedIdentifier((DBSObject)schema) + ".INFORMATION_SCHEMA.COLUMNS WHERE clustering_ordinal_position IS NOT NULL");){
                    Throwable throwable3 = null;
                    Object var13_19 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                            if (!CommonUtils.isNotEmpty((String)tableName)) continue;
                            clusteredTableNames.add(tableName);
                        }
                        if (!clusteredTableNames.isEmpty()) {
                            block18: for (String clusteredTableName : clusteredTableNames) {
                                for (GenericTable genericTable : tables) {
                                    void bigQueryTable;
                                    GenericTable genericTable2;
                                    if (!clusteredTableName.equals(genericTable.getName()) || !((genericTable2 = genericTable) instanceof BigQueryTable)) continue;
                                    BigQueryTable cfr_ignored_0 = (BigQueryTable)genericTable2;
                                    BigQueryTable cfr_ignored_1 = (BigQueryTable)genericTable2;
                                    bigQueryTable.setClustered(true);
                                    continue block18;
                                }
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.debug((Object)"Can't read table clustered status", (Throwable)e);
        }
        this.clusteredTableStatusLoaded = true;
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.clusteredTableStatusLoaded = false;
        return super.refreshObject(monitor);
    }

    public List<GenericProcedure> getProcedures(DBRProgressMonitor monitor) throws DBException {
        ArrayList<GenericProcedure> routines = new ArrayList<GenericProcedure>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read routines");){
            try {
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + DBUtils.getQuotedIdentifier((DBSObject)this.getCatalog()) + "." + DBUtils.getQuotedIdentifier((DBSObject)this.getSchema()) + ".INFORMATION_SCHEMA.ROUTINES");){
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String routineName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"routine_name");
                            String routineType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"routine_type");
                            String routineSource = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"routine_definition");
                            String routineDDL = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ddl");
                            String createdTime = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"created");
                            String alteredTime = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"last_altered");
                            String routineExtLang = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"external_language");
                            DBSProcedureType dsType = DBSProcedureType.PROCEDURE;
                            switch (routineType) {
                                case "FUNCTION": {
                                    dsType = DBSProcedureType.FUNCTION;
                                    break;
                                }
                                case "PROCEDURE": {
                                    dsType = DBSProcedureType.PROCEDURE;
                                    break;
                                }
                                default: {
                                    dsType = DBSProcedureType.UNKNOWN;
                                }
                            }
                            routines.add(new BigQueryRoutine(this.getCatalog(), this.getSchema(), routineName, routineName, createdTime, alteredTime, routineDDL, routineExtLang, dsType, routineSource, true));
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Exception e) {
                throw new DBException(e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        return routines;
    }
}

