/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model.session;

import java.sql.ResultSet;
import java.util.Objects;
import org.jkiss.dbeaver.model.admin.sessions.AbstractServerSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;

public class AltibaseServerSession
extends AbstractServerSession {
    public static final String CAT_SESSION = "Session";
    public static final String CAT_SQL = "SQL";
    public static final String CAT_WAIT = "Wait";
    public static final String CAT_TIMEOUT = "Timeout";
    private String sessionId;
    private String txId;
    private int stmtId;
    private String userName;
    private String sql;
    private String lockTarget;
    private String lockStatus;
    private String lockType;
    private String loginTime;
    private String loginIdleSince;
    private String autoCommit;
    private String sysdba;
    private String clientAppInfo;
    private String commName;
    private String clientType;
    private String clientProtocolVersion;
    private String clientPid;
    private String queryTimeLimit;
    private String ddlTimeLimit;
    private String fetchTimeLimit;
    private String utransTimeLimit;
    private String idleTimeLimit;
    private String nlsTerritory;
    private String timezone;

    public AltibaseServerSession(ResultSet dbResult) {
        this.sessionId = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"session_id");
        this.txId = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"tx_id");
        this.stmtId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"stmt_id");
        this.userName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"user_name");
        this.sql = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"sql");
        this.lockTarget = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"lock_target");
        this.lockStatus = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"lock_status");
        this.lockType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"lock_type");
        this.loginTime = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"login_time");
        this.loginIdleSince = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"idle_since");
        this.autoCommit = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"autocommit");
        this.sysdba = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"sysda");
        this.queryTimeLimit = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"QUERY_TIME_LIMIT");
        this.ddlTimeLimit = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DDL_TIME_LIMIT");
        this.fetchTimeLimit = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FETCH_TIME_LIMIT");
        this.utransTimeLimit = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"UTRANS_TIME_LIMIT");
        this.idleTimeLimit = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IDLE_TIME_LIMIT");
        this.clientAppInfo = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"client_app_info");
        this.commName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comm_name");
        this.clientType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"client_type");
        this.clientProtocolVersion = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"client_protocol_version");
        this.clientPid = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"client_pid");
        this.nlsTerritory = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NLS_TERRITORY");
        this.timezone = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TIME_ZONE");
    }

    @Property(category="Session", viewable=true, order=1)
    public String getSessionId() {
        return this.sessionId;
    }

    @Property(category="Session", viewable=true, order=2)
    public String getTxId() {
        return this.txId;
    }

    @Property(category="Session", viewable=true, order=3)
    public String getUserName() {
        return this.userName;
    }

    @Property(category="SQL", viewable=true, order=4)
    public String getSql() {
        String qry;
        int effectiveLength = 10;
        String string = qry = this.sql != null ? this.sql.trim() : "";
        if (CommonUtils.isNotEmpty((String)qry)) {
            if (qry.length() > effectiveLength) {
                qry = this.sql.trim().substring(0, 7);
            }
            qry = qry.replaceAll("[\\n\\t]", " ");
            qry = qry.replaceAll("[ ]+", " ");
        }
        return qry.length() > 0 ? qry + "..." : "";
    }

    @Property(category="Wait", viewable=true, order=5)
    public String getLockTarget() {
        return this.lockTarget;
    }

    @Property(category="Wait", viewable=true, order=6)
    public String getLockStatus() {
        return this.lockStatus;
    }

    @Property(category="Wait", viewable=true, order=7)
    public String getLockType() {
        return this.lockType;
    }

    @Property(category="Session", viewable=true, order=8)
    public String getLoginTime() {
        return this.loginTime;
    }

    @Property(category="Session", viewable=true, order=9)
    public String getIdleSince() {
        return this.loginIdleSince;
    }

    @Property(category="Session", viewable=true, order=10)
    public String getIsAutocommit() {
        return this.autoCommit;
    }

    @Property(category="Session", viewable=true, order=11)
    public String getIsSysdba() {
        return this.sysdba;
    }

    @Property(category="Session", viewable=true, order=20)
    public String getCommName() {
        return this.commName;
    }

    @Property(category="Session", viewable=true, order=21)
    public String getClientAppInfo() {
        return this.clientAppInfo;
    }

    @Property(category="Session", viewable=true, order=22)
    public String getClientType() {
        return this.clientType;
    }

    @Property(category="Session", viewable=true, order=23)
    public String getClientProtocolVersion() {
        return this.clientProtocolVersion;
    }

    @Property(category="Session", viewable=true, order=24)
    public String getClientPID() {
        return this.clientPid;
    }

    @Property(category="Session", viewable=true, order=25)
    public String getNlsTerritory() {
        return this.nlsTerritory;
    }

    @Property(category="Session", viewable=true, order=26)
    public String getTimeZone() {
        return this.timezone;
    }

    @Property(category="Timeout", viewable=true, order=30)
    public String getQueryTimeLimit() {
        return this.queryTimeLimit;
    }

    @Property(category="Timeout", viewable=true, order=31)
    public String getDdlTimeLimit() {
        return this.ddlTimeLimit;
    }

    @Property(category="Timeout", viewable=true, order=32)
    public String getFetchTimeLimit() {
        return this.fetchTimeLimit;
    }

    @Property(category="Timeout", viewable=true, order=33)
    public String getUtransTimeLimit() {
        return this.utransTimeLimit;
    }

    @Property(category="Timeout", viewable=true, order=34)
    public String getIdleTimeLimit() {
        return this.idleTimeLimit;
    }

    public String getActiveQuery() {
        return this.sql;
    }

    public Object getActiveQueryId() {
        return this.stmtId;
    }

    public String toString() {
        return this.sessionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (o instanceof AltibaseServerSession) {
            return this.sessionId == ((AltibaseServerSession)((Object)o)).sessionId;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.sessionId);
    }
}

