/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model.plan;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.plan.AltibasePlanNode;

public class AltibasePlanBuilder {
    private static final Log log = Log.getLog(AltibasePlanBuilder.class);

    public static List<AltibasePlanNode> build(AltibaseDataSource dataSource, String planStr) throws IllegalStateException {
        ArrayList<AltibasePlanNode> rootNodes = new ArrayList<AltibasePlanNode>();
        AltibasePlanNode node = null;
        AltibasePlanNode prevNode = null;
        String[] plans = planStr.split("\\n");
        int id = 0;
        String[] stringArray = plans;
        int n = plans.length;
        int n2 = 0;
        while (n2 < n) {
            String plan = stringArray[n2];
            if (plan != null && plan.trim().length() >= 1 && !plan.startsWith("---")) {
                if (plan.trim().startsWith("* SIMPLE")) break;
                int depth = plan.indexOf(plan.trim());
                plan = plan.trim();
                if (depth == 0 && prevNode == null) {
                    node = new AltibasePlanNode(dataSource, id++, 0, plan, null);
                    rootNodes.add(node);
                } else if (depth > 0 && prevNode != null) {
                    node = prevNode.getDepth() == depth ? new AltibasePlanNode(dataSource, id++, depth, plan, (AltibasePlanNode)prevNode.getParent()) : (prevNode.getDepth() < depth ? new AltibasePlanNode(dataSource, id++, depth, plan, prevNode) : new AltibasePlanNode(dataSource, id++, depth, plan, prevNode.getParentNodeAtDepth(depth)));
                } else {
                    throw new IllegalStateException("Plan parsing error [depth: " + depth + "]: " + plan + "\n" + planStr);
                }
                prevNode = node;
            }
            ++n2;
        }
        return rootNodes;
    }

    public static void main(String[] args) {
        String plan = "-----------------------------------------------------------\nPROJECT ( COLUMN_COUNT: 2, TUPLE_SIZE: 34, COST: 151146.46 )\n JOIN ( METHOD: NL, COST: 148444.31 )\n  SCAN ( TABLE: CUSTOMERS, FULL SCAN, ACCESS: ??, COST: 116.76 )\n  VIEW ( ORDERS_T, ACCESS: ??, COST: 14.49 )\n   PROJECT ( COLUMN_COUNT: 6, TUPLE_SIZE: 48, COST: 2.81 )\n    VIEW ( ACCESS: ??, COST: 2.02 )\n     BAG-UNION\n      PROJECT ( COLUMN_COUNT: 6, TUPLE_SIZE: 48, COST: 0.67 )\n       SCAN ( TABLE: ORDERS ORDERS_01, INDEX: SYS.ODR_IDX2, RANGE SCAN, ACCESS: ??, COST: 0.41 )\n        [ VARIABLE KEY ]\n        OR\n         AND\n          CUSTOMERS.CNO = ORDERS_01.CNO\n        [ FILTER ]\n        ORDERS_01.QTY >= 10000\n      PROJECT ( COLUMN_COUNT: 6, TUPLE_SIZE: 48, COST: 0.67 )\n       SCAN ( TABLE: ORDERS ORDERS_02, INDEX: SYS.ODR_IDX2, RANGE SCAN, ACCESS: ??, COST: 0.41 )\n        [ VARIABLE KEY ]\n        OR\n         AND\n          CUSTOMERS.CNO = ORDERS_02.CNO\n        [ FILTER ]\n        ORDERS_02.QTY >= 10000\n      PROJECT ( COLUMN_COUNT: 6, TUPLE_SIZE: 48, COST: 0.67 )\n       SCAN ( TABLE: ORDERS ORDERS_03, INDEX: ODR_IDX2, RANGE SCAN, ACCESS: ??, COST: 0.41 ) \n        [ VARIABLE KEY ]\n        OR\n         AND\n          CUSTOMERS.CNO = ORDERS_03.CNO\n        [ FILTER ]\n        ORDERS_03.QTY >= 10000\n-----------------------------------------------------------* SIMPLE QUERY PLAN";
    }
}

