/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseMaterializedView;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseQueue;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTable;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTypeset;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseView;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class AltibaseSchema
extends GenericSchema
implements DBPObjectStatisticsCollector {
    private volatile boolean hasStatistics;

    public AltibaseSchema(GenericDataSource dataSource, GenericCatalog catalog, String schemaName) {
        super(dataSource, catalog, schemaName);
    }

    public List<AltibaseTable> getPhysicalTables(DBRProgressMonitor monitor) throws DBException {
        List tables = this.getTables(monitor);
        if (tables != null) {
            ArrayList<AltibaseTable> filtered = new ArrayList<AltibaseTable>();
            for (GenericTableBase table : tables) {
                if (!(table instanceof AltibaseTable)) continue;
                filtered.add((AltibaseTable)table);
            }
            return filtered;
        }
        return null;
    }

    public List<AltibaseQueue> getQueueTables(DBRProgressMonitor monitor) throws DBException {
        List tables = this.getTables(monitor);
        if (tables != null) {
            ArrayList<AltibaseQueue> filtered = new ArrayList<AltibaseQueue>();
            for (GenericTableBase table : tables) {
                if (!(table instanceof AltibaseQueue)) continue;
                filtered.add((AltibaseQueue)table);
            }
            return filtered;
        }
        return null;
    }

    public List<AltibaseView> getViews(DBRProgressMonitor monitor) throws DBException {
        List tables = this.getTables(monitor);
        if (tables != null) {
            ArrayList<AltibaseView> filtered = new ArrayList<AltibaseView>();
            for (GenericTableBase table : tables) {
                if (!(table instanceof AltibaseView)) continue;
                filtered.add((AltibaseView)table);
            }
            return filtered;
        }
        return null;
    }

    public List<AltibaseMaterializedView> getMaterializedViews(DBRProgressMonitor monitor) throws DBException {
        List tables = this.getTables(monitor);
        if (tables != null) {
            ArrayList<AltibaseMaterializedView> filtered = new ArrayList<AltibaseMaterializedView>();
            for (GenericTableBase table : tables) {
                if (!(table instanceof AltibaseMaterializedView)) continue;
                filtered.add((AltibaseMaterializedView)table);
            }
            return filtered;
        }
        return null;
    }

    public List<AltibaseTypeset> getTypesetsOnly(DBRProgressMonitor monitor) throws DBException {
        ArrayList<AltibaseTypeset> filteredProcedures = new ArrayList<AltibaseTypeset>();
        for (GenericProcedure proc : CommonUtils.safeList((List)this.getProcedures(monitor))) {
            if (!(proc instanceof AltibaseTypeset)) continue;
            filteredProcedures.add((AltibaseTypeset)proc);
        }
        return filteredProcedures;
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.hasStatistics = false;
        return this;
    }

    public GenericTableIndex getIndex(DBRProgressMonitor monitor, String uniqueName) throws DBException {
        for (GenericTableIndex index : CommonUtils.safeCollection((Collection)this.getIndexes(monitor))) {
            if (!uniqueName.equals(index.getName())) continue;
            return index;
        }
        return null;
    }

    public GenericTrigger getTableTrigger(DBRProgressMonitor monitor, String uniqueName) throws DBException {
        for (GenericTrigger tableTrigger : CommonUtils.safeCollection((Collection)this.getTableTriggers(monitor))) {
            if (!uniqueName.equals(tableTrigger.getName())) continue;
            return tableTrigger;
        }
        return null;
    }

    public GenericProcedure getProcedureByName(DBRProgressMonitor monitor, String name) throws DBException {
        for (GenericProcedure procedure : CommonUtils.safeCollection((Collection)this.getProcedures(monitor))) {
            if (!name.equals(procedure.getName())) continue;
            return procedure;
        }
        return null;
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        Iterator iterator;
        block29: {
            if (this.hasStatistics && !forceRefresh) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");
                    try {
                        Throwable throwable2 = null;
                        Object var8_12 = null;
                        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT table_name, memory_size, disk_size FROM system_.sys_table_size_ WHERE USER_NAME = ?");){
                            dbStat.setString(1, this.getName());
                            Throwable throwable3 = null;
                            Object var11_17 = null;
                            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                                while (dbResult.next()) {
                                    String tableName = dbResult.getString(1);
                                    AltibaseTable table = (AltibaseTable)this.getTable(monitor, tableName);
                                    if (table == null) continue;
                                    table.fetchTableSize(dbResult);
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                    throw throwable3;
                                }
                                if (throwable3 == throwable4) throw throwable3;
                                throwable3.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                                throw throwable2;
                            }
                            if (throwable2 == throwable5) throw throwable2;
                            throwable2.addSuppressed(throwable5);
                            throw throwable2;
                        }
                        if (session == null) break block29;
                    }
                    catch (Throwable throwable6) {
                        if (session == null) throw throwable6;
                        session.close();
                        throw throwable6;
                    }
                    session.close();
                }
                catch (Throwable throwable7) {
                    if (throwable == null) {
                        throwable = throwable7;
                        throw throwable;
                    }
                    if (throwable == throwable7) throw throwable;
                    throwable.addSuppressed(throwable7);
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException("Error reading table statistics", (Throwable)e);
            }
            finally {
                iterator = this.getTableCache().getCachedObjects().iterator();
                break;
            }
        }
        while (true) {
            if (!iterator.hasNext()) {
                this.hasStatistics = true;
                return;
            }
            GenericTableBase table = (GenericTableBase)iterator.next();
            if (!(table instanceof AltibaseTable) || ((AltibaseTable)table).hasStatistics()) continue;
            ((AltibaseTable)table).resetSize();
        }
    }
}

